<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDERERCONTACTPERSON StructType
 * @subpackage Structs
 */
class ORDERERCONTACTPERSON extends AbstractStructBase
{
    /**
     * The ORDERERCONTACTPERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ORDERERCONTACTPERSON_OBJID;
    /**
     * The ORDERERCONTACTPERSON_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ORDERERCONTACTPERSON_CENTRALID;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastnamefirstname;
    /**
     * Constructor method for ORDERERCONTACTPERSON
     * @uses ORDERERCONTACTPERSON::setORDERERCONTACTPERSON_OBJID()
     * @uses ORDERERCONTACTPERSON::setORDERERCONTACTPERSON_CENTRALID()
     * @uses ORDERERCONTACTPERSON::setLastnamefirstname()
     * @param string $oRDERERCONTACTPERSON_OBJID
     * @param string $oRDERERCONTACTPERSON_CENTRALID
     * @param string $lastnamefirstname
     */
    public function __construct($oRDERERCONTACTPERSON_OBJID = null, $oRDERERCONTACTPERSON_CENTRALID = null, $lastnamefirstname = null)
    {
        $this
            ->setORDERERCONTACTPERSON_OBJID($oRDERERCONTACTPERSON_OBJID)
            ->setORDERERCONTACTPERSON_CENTRALID($oRDERERCONTACTPERSON_CENTRALID)
            ->setLastnamefirstname($lastnamefirstname);
    }
    /**
     * Get ORDERERCONTACTPERSON_OBJID value
     * @return string
     */
    public function getORDERERCONTACTPERSON_OBJID()
    {
        return $this->{'ORDERERCONTACTPERSON-OBJID'};
    }
    /**
     * Set ORDERERCONTACTPERSON_OBJID value
     * @param string $oRDERERCONTACTPERSON_OBJID
     * @return \StructType\ORDERERCONTACTPERSON
     */
    public function setORDERERCONTACTPERSON_OBJID($oRDERERCONTACTPERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($oRDERERCONTACTPERSON_OBJID) && !is_string($oRDERERCONTACTPERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDERERCONTACTPERSON_OBJID, true), gettype($oRDERERCONTACTPERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($oRDERERCONTACTPERSON_OBJID) && !preg_match('/([0-9])*/', $oRDERERCONTACTPERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($oRDERERCONTACTPERSON_OBJID, true)), __LINE__);
        }
        $this->ORDERERCONTACTPERSON_OBJID = $this->{'ORDERERCONTACTPERSON-OBJID'} = $oRDERERCONTACTPERSON_OBJID;
        return $this;
    }
    /**
     * Get ORDERERCONTACTPERSON_CENTRALID value
     * @return string
     */
    public function getORDERERCONTACTPERSON_CENTRALID()
    {
        return $this->{'ORDERERCONTACTPERSON-CENTRALID'};
    }
    /**
     * Set ORDERERCONTACTPERSON_CENTRALID value
     * @param string $oRDERERCONTACTPERSON_CENTRALID
     * @return \StructType\ORDERERCONTACTPERSON
     */
    public function setORDERERCONTACTPERSON_CENTRALID($oRDERERCONTACTPERSON_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($oRDERERCONTACTPERSON_CENTRALID) && !is_string($oRDERERCONTACTPERSON_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDERERCONTACTPERSON_CENTRALID, true), gettype($oRDERERCONTACTPERSON_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($oRDERERCONTACTPERSON_CENTRALID) && !preg_match('/([0-9])*/', $oRDERERCONTACTPERSON_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($oRDERERCONTACTPERSON_CENTRALID, true)), __LINE__);
        }
        $this->ORDERERCONTACTPERSON_CENTRALID = $this->{'ORDERERCONTACTPERSON-CENTRALID'} = $oRDERERCONTACTPERSON_CENTRALID;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\ORDERERCONTACTPERSON
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
}
