<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamelistGroup StructType
 * @subpackage Structs
 */
class NamelistGroup extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip;
    /**
     * The Orderer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Orderer;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The printurl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $printurl;
    /**
     * The regcardpdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $regcardpdf;
    /**
     * The ROOMINGLIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMINGLIST_OBJID;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person[]
     */
    public $Person;
    /**
     * The PersonList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonList[]
     */
    public $PersonList;
    /**
     * The PINamelistGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PINamelistGroup[]
     */
    public $PINamelistGroup;
    /**
     * Constructor method for NamelistGroup
     * @uses NamelistGroup::setRESERVATION_OBJID()
     * @uses NamelistGroup::setRoom()
     * @uses NamelistGroup::setVip()
     * @uses NamelistGroup::setOrderer()
     * @uses NamelistGroup::setResno()
     * @uses NamelistGroup::setCategory()
     * @uses NamelistGroup::setDateto()
     * @uses NamelistGroup::setPrinturl()
     * @uses NamelistGroup::setRegcardpdf()
     * @uses NamelistGroup::setROOMINGLIST_OBJID()
     * @uses NamelistGroup::setDatefrom()
     * @uses NamelistGroup::setPerson()
     * @uses NamelistGroup::setPersonList()
     * @uses NamelistGroup::setPINamelistGroup()
     * @param string $rESERVATION_OBJID
     * @param string $room
     * @param string $vip
     * @param string $orderer
     * @param string $resno
     * @param string $category
     * @param string $dateto
     * @param string $printurl
     * @param string $regcardpdf
     * @param string $rOOMINGLIST_OBJID
     * @param string $datefrom
     * @param \StructType\Person[] $person
     * @param \StructType\PersonList[] $personList
     * @param \StructType\PINamelistGroup[] $pINamelistGroup
     */
    public function __construct($rESERVATION_OBJID = null, $room = null, $vip = null, $orderer = null, $resno = null, $category = null, $dateto = null, $printurl = null, $regcardpdf = null, $rOOMINGLIST_OBJID = null, $datefrom = null, array $person = array(), array $personList = array(), array $pINamelistGroup = array())
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setRoom($room)
            ->setVip($vip)
            ->setOrderer($orderer)
            ->setResno($resno)
            ->setCategory($category)
            ->setDateto($dateto)
            ->setPrinturl($printurl)
            ->setRegcardpdf($regcardpdf)
            ->setROOMINGLIST_OBJID($rOOMINGLIST_OBJID)
            ->setDatefrom($datefrom)
            ->setPerson($person)
            ->setPersonList($personList)
            ->setPINamelistGroup($pINamelistGroup);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\NamelistGroup
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\NamelistGroup
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get vip value
     * @return string
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\NamelistGroup
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip) && mb_strlen($vip) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip) && mb_strlen($vip) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get Orderer value
     * @return string
     */
    public function getOrderer()
    {
        return $this->Orderer;
    }
    /**
     * Set Orderer value
     * @param string $orderer
     * @return \StructType\NamelistGroup
     */
    public function setOrderer($orderer = null)
    {
        // validation for constraint: string
        if (!is_null($orderer) && !is_string($orderer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderer, true), gettype($orderer)), __LINE__);
        }
        $this->Orderer = $orderer;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\NamelistGroup
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\NamelistGroup
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\NamelistGroup
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get printurl value
     * @return string
     */
    public function getPrinturl()
    {
        return $this->printurl;
    }
    /**
     * Set printurl value
     * @param string $printurl
     * @return \StructType\NamelistGroup
     */
    public function setPrinturl($printurl = null)
    {
        // validation for constraint: string
        if (!is_null($printurl) && !is_string($printurl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printurl, true), gettype($printurl)), __LINE__);
        }
        $this->printurl = $printurl;
        return $this;
    }
    /**
     * Get regcardpdf value
     * @return string
     */
    public function getRegcardpdf()
    {
        return $this->regcardpdf;
    }
    /**
     * Set regcardpdf value
     * @param string $regcardpdf
     * @return \StructType\NamelistGroup
     */
    public function setRegcardpdf($regcardpdf = null)
    {
        // validation for constraint: string
        if (!is_null($regcardpdf) && !is_string($regcardpdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regcardpdf, true), gettype($regcardpdf)), __LINE__);
        }
        $this->regcardpdf = $regcardpdf;
        return $this;
    }
    /**
     * Get ROOMINGLIST_OBJID value
     * @return string
     */
    public function getROOMINGLIST_OBJID()
    {
        return $this->{'ROOMINGLIST-OBJID'};
    }
    /**
     * Set ROOMINGLIST_OBJID value
     * @param string $rOOMINGLIST_OBJID
     * @return \StructType\NamelistGroup
     */
    public function setROOMINGLIST_OBJID($rOOMINGLIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMINGLIST_OBJID) && !is_string($rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMINGLIST_OBJID, true), gettype($rOOMINGLIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMINGLIST_OBJID) && !preg_match('/([0-9])*/', $rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMINGLIST_OBJID, true)), __LINE__);
        }
        $this->ROOMINGLIST_OBJID = $this->{'ROOMINGLIST-OBJID'} = $rOOMINGLIST_OBJID;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\NamelistGroup
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonForArrayConstraintsFromSetPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $namelistGroupPersonItem) {
            // validation for constraint: itemType
            if (!$namelistGroupPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($namelistGroupPersonItem) ? get_class($namelistGroupPersonItem) : sprintf('%s(%s)', gettype($namelistGroupPersonItem), var_export($namelistGroupPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person[] $person
     * @return \StructType\NamelistGroup
     */
    public function setPerson(array $person = array())
    {
        // validation for constraint: array
        if ('' !== ($personArrayErrorMessage = self::validatePersonForArrayConstraintsFromSetPerson($person))) {
            throw new \InvalidArgumentException($personArrayErrorMessage, __LINE__);
        }
        $this->Person = $person;
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \StructType\NamelistGroup
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
    /**
     * Get PersonList value
     * @return \StructType\PersonList[]|null
     */
    public function getPersonList()
    {
        return $this->PersonList;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonListForArrayConstraintsFromSetPersonList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $namelistGroupPersonListItem) {
            // validation for constraint: itemType
            if (!$namelistGroupPersonListItem instanceof \StructType\PersonList) {
                $invalidValues[] = is_object($namelistGroupPersonListItem) ? get_class($namelistGroupPersonListItem) : sprintf('%s(%s)', gettype($namelistGroupPersonListItem), var_export($namelistGroupPersonListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonList property can only contain items of type \StructType\PersonList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonList value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonList[] $personList
     * @return \StructType\NamelistGroup
     */
    public function setPersonList(array $personList = array())
    {
        // validation for constraint: array
        if ('' !== ($personListArrayErrorMessage = self::validatePersonListForArrayConstraintsFromSetPersonList($personList))) {
            throw new \InvalidArgumentException($personListArrayErrorMessage, __LINE__);
        }
        $this->PersonList = $personList;
        return $this;
    }
    /**
     * Add item to PersonList value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonList $item
     * @return \StructType\NamelistGroup
     */
    public function addToPersonList(\StructType\PersonList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonList) {
            throw new \InvalidArgumentException(sprintf('The PersonList property can only contain items of type \StructType\PersonList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonList[] = $item;
        return $this;
    }
    /**
     * Get PINamelistGroup value
     * @return \StructType\PINamelistGroup[]|null
     */
    public function getPINamelistGroup()
    {
        return $this->PINamelistGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setPINamelistGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPINamelistGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePINamelistGroupForArrayConstraintsFromSetPINamelistGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $namelistGroupPINamelistGroupItem) {
            // validation for constraint: itemType
            if (!$namelistGroupPINamelistGroupItem instanceof \StructType\PINamelistGroup) {
                $invalidValues[] = is_object($namelistGroupPINamelistGroupItem) ? get_class($namelistGroupPINamelistGroupItem) : sprintf('%s(%s)', gettype($namelistGroupPINamelistGroupItem), var_export($namelistGroupPINamelistGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PINamelistGroup property can only contain items of type \StructType\PINamelistGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PINamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PINamelistGroup[] $pINamelistGroup
     * @return \StructType\NamelistGroup
     */
    public function setPINamelistGroup(array $pINamelistGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($pINamelistGroupArrayErrorMessage = self::validatePINamelistGroupForArrayConstraintsFromSetPINamelistGroup($pINamelistGroup))) {
            throw new \InvalidArgumentException($pINamelistGroupArrayErrorMessage, __LINE__);
        }
        $this->PINamelistGroup = $pINamelistGroup;
        return $this;
    }
    /**
     * Add item to PINamelistGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PINamelistGroup $item
     * @return \StructType\NamelistGroup
     */
    public function addToPINamelistGroup(\StructType\PINamelistGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PINamelistGroup) {
            throw new \InvalidArgumentException(sprintf('The PINamelistGroup property can only contain items of type \StructType\PINamelistGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PINamelistGroup[] = $item;
        return $this;
    }
}
