<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTIFICATION-UNREGISTER StructType
 * @subpackage Structs
 */
class NOTIFICATION_UNREGISTER extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $key;
    /**
     * Constructor method for NOTIFICATION-UNREGISTER
     * @uses NOTIFICATION_UNREGISTER::setKey()
     * @param string $key
     */
    public function __construct($key = null)
    {
        $this
            ->setKey($key);
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\NOTIFICATION_UNREGISTER
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($key) && !preg_match('/([-+]){0,1}([0-9])*/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($key, true)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
}
