<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOARRIVALS StructType
 * @subpackage Structs
 */
class NOARRIVALS extends AbstractStructBase
{
    /**
     * The sunday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $sunday;
    /**
     * The monday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $monday;
    /**
     * The tuesday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $tuesday;
    /**
     * The wednesday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $wednesday;
    /**
     * The thursday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $thursday;
    /**
     * The friday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $friday;
    /**
     * The saturday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $saturday;
    /**
     * Constructor method for NOARRIVALS
     * @uses NOARRIVALS::setSunday()
     * @uses NOARRIVALS::setMonday()
     * @uses NOARRIVALS::setTuesday()
     * @uses NOARRIVALS::setWednesday()
     * @uses NOARRIVALS::setThursday()
     * @uses NOARRIVALS::setFriday()
     * @uses NOARRIVALS::setSaturday()
     * @param string $sunday
     * @param string $monday
     * @param string $tuesday
     * @param string $wednesday
     * @param string $thursday
     * @param string $friday
     * @param string $saturday
     */
    public function __construct($sunday = null, $monday = null, $tuesday = null, $wednesday = null, $thursday = null, $friday = null, $saturday = null)
    {
        $this
            ->setSunday($sunday)
            ->setMonday($monday)
            ->setTuesday($tuesday)
            ->setWednesday($wednesday)
            ->setThursday($thursday)
            ->setFriday($friday)
            ->setSaturday($saturday);
    }
    /**
     * Get sunday value
     * @return string
     */
    public function getSunday()
    {
        return $this->sunday;
    }
    /**
     * Set sunday value
     * @param string $sunday
     * @return \StructType\NOARRIVALS
     */
    public function setSunday($sunday = null)
    {
        // validation for constraint: string
        if (!is_null($sunday) && !is_string($sunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sunday, true), gettype($sunday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($sunday) && !preg_match('/([-+]){0,1}([0-9])*/', $sunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($sunday, true)), __LINE__);
        }
        $this->sunday = $sunday;
        return $this;
    }
    /**
     * Get monday value
     * @return string
     */
    public function getMonday()
    {
        return $this->monday;
    }
    /**
     * Set monday value
     * @param string $monday
     * @return \StructType\NOARRIVALS
     */
    public function setMonday($monday = null)
    {
        // validation for constraint: string
        if (!is_null($monday) && !is_string($monday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monday, true), gettype($monday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($monday) && !preg_match('/([-+]){0,1}([0-9])*/', $monday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($monday, true)), __LINE__);
        }
        $this->monday = $monday;
        return $this;
    }
    /**
     * Get tuesday value
     * @return string
     */
    public function getTuesday()
    {
        return $this->tuesday;
    }
    /**
     * Set tuesday value
     * @param string $tuesday
     * @return \StructType\NOARRIVALS
     */
    public function setTuesday($tuesday = null)
    {
        // validation for constraint: string
        if (!is_null($tuesday) && !is_string($tuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tuesday, true), gettype($tuesday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($tuesday) && !preg_match('/([-+]){0,1}([0-9])*/', $tuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($tuesday, true)), __LINE__);
        }
        $this->tuesday = $tuesday;
        return $this;
    }
    /**
     * Get wednesday value
     * @return string
     */
    public function getWednesday()
    {
        return $this->wednesday;
    }
    /**
     * Set wednesday value
     * @param string $wednesday
     * @return \StructType\NOARRIVALS
     */
    public function setWednesday($wednesday = null)
    {
        // validation for constraint: string
        if (!is_null($wednesday) && !is_string($wednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wednesday, true), gettype($wednesday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($wednesday) && !preg_match('/([-+]){0,1}([0-9])*/', $wednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($wednesday, true)), __LINE__);
        }
        $this->wednesday = $wednesday;
        return $this;
    }
    /**
     * Get thursday value
     * @return string
     */
    public function getThursday()
    {
        return $this->thursday;
    }
    /**
     * Set thursday value
     * @param string $thursday
     * @return \StructType\NOARRIVALS
     */
    public function setThursday($thursday = null)
    {
        // validation for constraint: string
        if (!is_null($thursday) && !is_string($thursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thursday, true), gettype($thursday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($thursday) && !preg_match('/([-+]){0,1}([0-9])*/', $thursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($thursday, true)), __LINE__);
        }
        $this->thursday = $thursday;
        return $this;
    }
    /**
     * Get friday value
     * @return string
     */
    public function getFriday()
    {
        return $this->friday;
    }
    /**
     * Set friday value
     * @param string $friday
     * @return \StructType\NOARRIVALS
     */
    public function setFriday($friday = null)
    {
        // validation for constraint: string
        if (!is_null($friday) && !is_string($friday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($friday, true), gettype($friday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($friday) && !preg_match('/([-+]){0,1}([0-9])*/', $friday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($friday, true)), __LINE__);
        }
        $this->friday = $friday;
        return $this;
    }
    /**
     * Get saturday value
     * @return string
     */
    public function getSaturday()
    {
        return $this->saturday;
    }
    /**
     * Set saturday value
     * @param string $saturday
     * @return \StructType\NOARRIVALS
     */
    public function setSaturday($saturday = null)
    {
        // validation for constraint: string
        if (!is_null($saturday) && !is_string($saturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturday, true), gettype($saturday)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($saturday) && !preg_match('/([-+]){0,1}([0-9])*/', $saturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($saturday, true)), __LINE__);
        }
        $this->saturday = $saturday;
        return $this;
    }
}
