<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModuleRoomServiceRes StructType
 * @subpackage Structs
 */
class ModuleRoomServiceRes extends AbstractStructBase
{
    /**
     * The MODULE_ROOM_SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $MODULE_ROOM_SERVICE_OBJID;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The timefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timefrom;
    /**
     * The timeto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timeto;
    /**
     * The numberliteral
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $numberliteral;
    /**
     * The postingtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postingtype;
    /**
     * Constructor method for ModuleRoomServiceRes
     * @uses ModuleRoomServiceRes::setMODULE_ROOM_SERVICE_OBJID()
     * @uses ModuleRoomServiceRes::setService()
     * @uses ModuleRoomServiceRes::setDate()
     * @uses ModuleRoomServiceRes::setTimefrom()
     * @uses ModuleRoomServiceRes::setTimeto()
     * @uses ModuleRoomServiceRes::setNumberliteral()
     * @uses ModuleRoomServiceRes::setPostingtype()
     * @param string $mODULE_ROOM_SERVICE_OBJID
     * @param string $service
     * @param string $date
     * @param string $timefrom
     * @param string $timeto
     * @param string $numberliteral
     * @param string $postingtype
     */
    public function __construct($mODULE_ROOM_SERVICE_OBJID = null, $service = null, $date = null, $timefrom = null, $timeto = null, $numberliteral = null, $postingtype = null)
    {
        $this
            ->setMODULE_ROOM_SERVICE_OBJID($mODULE_ROOM_SERVICE_OBJID)
            ->setService($service)
            ->setDate($date)
            ->setTimefrom($timefrom)
            ->setTimeto($timeto)
            ->setNumberliteral($numberliteral)
            ->setPostingtype($postingtype);
    }
    /**
     * Get MODULE_ROOM_SERVICE_OBJID value
     * @return string
     */
    public function getMODULE_ROOM_SERVICE_OBJID()
    {
        return $this->{'MODULE-ROOM-SERVICE-OBJID'};
    }
    /**
     * Set MODULE_ROOM_SERVICE_OBJID value
     * @param string $mODULE_ROOM_SERVICE_OBJID
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setMODULE_ROOM_SERVICE_OBJID($mODULE_ROOM_SERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($mODULE_ROOM_SERVICE_OBJID) && !is_string($mODULE_ROOM_SERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mODULE_ROOM_SERVICE_OBJID, true), gettype($mODULE_ROOM_SERVICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($mODULE_ROOM_SERVICE_OBJID) && !preg_match('/([0-9])*/', $mODULE_ROOM_SERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($mODULE_ROOM_SERVICE_OBJID, true)), __LINE__);
        }
        $this->MODULE_ROOM_SERVICE_OBJID = $this->{'MODULE-ROOM-SERVICE-OBJID'} = $mODULE_ROOM_SERVICE_OBJID;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get timefrom value
     * @return string
     */
    public function getTimefrom()
    {
        return $this->timefrom;
    }
    /**
     * Set timefrom value
     * @param string $timefrom
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setTimefrom($timefrom = null)
    {
        // validation for constraint: string
        if (!is_null($timefrom) && !is_string($timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timefrom, true), gettype($timefrom)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timefrom) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timefrom, true)), __LINE__);
        }
        $this->timefrom = $timefrom;
        return $this;
    }
    /**
     * Get timeto value
     * @return string
     */
    public function getTimeto()
    {
        return $this->timeto;
    }
    /**
     * Set timeto value
     * @param string $timeto
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setTimeto($timeto = null)
    {
        // validation for constraint: string
        if (!is_null($timeto) && !is_string($timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeto, true), gettype($timeto)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timeto) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timeto, true)), __LINE__);
        }
        $this->timeto = $timeto;
        return $this;
    }
    /**
     * Get numberliteral value
     * @return string
     */
    public function getNumberliteral()
    {
        return $this->numberliteral;
    }
    /**
     * Set numberliteral value
     * @param string $numberliteral
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setNumberliteral($numberliteral = null)
    {
        // validation for constraint: string
        if (!is_null($numberliteral) && !is_string($numberliteral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberliteral, true), gettype($numberliteral)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($numberliteral) && !preg_match('/([-+]){0,1}([0-9])*/', $numberliteral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($numberliteral, true)), __LINE__);
        }
        $this->numberliteral = $numberliteral;
        return $this;
    }
    /**
     * Get postingtype value
     * @return string
     */
    public function getPostingtype()
    {
        return $this->postingtype;
    }
    /**
     * Set postingtype value
     * @param string $postingtype
     * @return \StructType\ModuleRoomServiceRes
     */
    public function setPostingtype($postingtype = null)
    {
        // validation for constraint: string
        if (!is_null($postingtype) && !is_string($postingtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingtype, true), gettype($postingtype)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($postingtype) && mb_strlen($postingtype) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($postingtype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postingtype) && mb_strlen($postingtype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postingtype)), __LINE__);
        }
        $this->postingtype = $postingtype;
        return $this;
    }
}
