<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModuleReservation StructType
 * @subpackage Structs
 */
class ModuleReservation extends AbstractStructBase
{
    /**
     * The ModuleReservation_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ModuleReservation_OBJID;
    /**
     * The ServiceReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceReservation[]
     */
    public $ServiceReservation;
    /**
     * The PackageReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackageReservation[]
     */
    public $PackageReservation;
    /**
     * The RoomReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomReservation[]
     */
    public $RoomReservation;
    /**
     * Constructor method for ModuleReservation
     * @uses ModuleReservation::setModuleReservation_OBJID()
     * @uses ModuleReservation::setServiceReservation()
     * @uses ModuleReservation::setPackageReservation()
     * @uses ModuleReservation::setRoomReservation()
     * @param string $moduleReservation_OBJID
     * @param \StructType\ServiceReservation[] $serviceReservation
     * @param \StructType\PackageReservation[] $packageReservation
     * @param \StructType\RoomReservation[] $roomReservation
     */
    public function __construct($moduleReservation_OBJID = null, array $serviceReservation = array(), array $packageReservation = array(), array $roomReservation = array())
    {
        $this
            ->setModuleReservation_OBJID($moduleReservation_OBJID)
            ->setServiceReservation($serviceReservation)
            ->setPackageReservation($packageReservation)
            ->setRoomReservation($roomReservation);
    }
    /**
     * Get ModuleReservation_OBJID value
     * @return string
     */
    public function getModuleReservation_OBJID()
    {
        return $this->{'ModuleReservation-OBJID'};
    }
    /**
     * Set ModuleReservation_OBJID value
     * @param string $moduleReservation_OBJID
     * @return \StructType\ModuleReservation
     */
    public function setModuleReservation_OBJID($moduleReservation_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($moduleReservation_OBJID) && !is_string($moduleReservation_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moduleReservation_OBJID, true), gettype($moduleReservation_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($moduleReservation_OBJID) && !preg_match('/([0-9])*/', $moduleReservation_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($moduleReservation_OBJID, true)), __LINE__);
        }
        $this->ModuleReservation_OBJID = $this->{'ModuleReservation-OBJID'} = $moduleReservation_OBJID;
        return $this;
    }
    /**
     * Get ServiceReservation value
     * @return \StructType\ServiceReservation[]|null
     */
    public function getServiceReservation()
    {
        return $this->ServiceReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceReservationForArrayConstraintsFromSetServiceReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $moduleReservationServiceReservationItem) {
            // validation for constraint: itemType
            if (!$moduleReservationServiceReservationItem instanceof \StructType\ServiceReservation) {
                $invalidValues[] = is_object($moduleReservationServiceReservationItem) ? get_class($moduleReservationServiceReservationItem) : sprintf('%s(%s)', gettype($moduleReservationServiceReservationItem), var_export($moduleReservationServiceReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceReservation property can only contain items of type \StructType\ServiceReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReservation[] $serviceReservation
     * @return \StructType\ModuleReservation
     */
    public function setServiceReservation(array $serviceReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceReservationArrayErrorMessage = self::validateServiceReservationForArrayConstraintsFromSetServiceReservation($serviceReservation))) {
            throw new \InvalidArgumentException($serviceReservationArrayErrorMessage, __LINE__);
        }
        $this->ServiceReservation = $serviceReservation;
        return $this;
    }
    /**
     * Add item to ServiceReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceReservation $item
     * @return \StructType\ModuleReservation
     */
    public function addToServiceReservation(\StructType\ServiceReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceReservation) {
            throw new \InvalidArgumentException(sprintf('The ServiceReservation property can only contain items of type \StructType\ServiceReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceReservation[] = $item;
        return $this;
    }
    /**
     * Get PackageReservation value
     * @return \StructType\PackageReservation[]|null
     */
    public function getPackageReservation()
    {
        return $this->PackageReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageReservationForArrayConstraintsFromSetPackageReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $moduleReservationPackageReservationItem) {
            // validation for constraint: itemType
            if (!$moduleReservationPackageReservationItem instanceof \StructType\PackageReservation) {
                $invalidValues[] = is_object($moduleReservationPackageReservationItem) ? get_class($moduleReservationPackageReservationItem) : sprintf('%s(%s)', gettype($moduleReservationPackageReservationItem), var_export($moduleReservationPackageReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation[] $packageReservation
     * @return \StructType\ModuleReservation
     */
    public function setPackageReservation(array $packageReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($packageReservationArrayErrorMessage = self::validatePackageReservationForArrayConstraintsFromSetPackageReservation($packageReservation))) {
            throw new \InvalidArgumentException($packageReservationArrayErrorMessage, __LINE__);
        }
        $this->PackageReservation = $packageReservation;
        return $this;
    }
    /**
     * Add item to PackageReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation $item
     * @return \StructType\ModuleReservation
     */
    public function addToPackageReservation(\StructType\PackageReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageReservation) {
            throw new \InvalidArgumentException(sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageReservation[] = $item;
        return $this;
    }
    /**
     * Get RoomReservation value
     * @return \StructType\RoomReservation[]|null
     */
    public function getRoomReservation()
    {
        return $this->RoomReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomReservationForArrayConstraintsFromSetRoomReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $moduleReservationRoomReservationItem) {
            // validation for constraint: itemType
            if (!$moduleReservationRoomReservationItem instanceof \StructType\RoomReservation) {
                $invalidValues[] = is_object($moduleReservationRoomReservationItem) ? get_class($moduleReservationRoomReservationItem) : sprintf('%s(%s)', gettype($moduleReservationRoomReservationItem), var_export($moduleReservationRoomReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomReservation property can only contain items of type \StructType\RoomReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomReservation[] $roomReservation
     * @return \StructType\ModuleReservation
     */
    public function setRoomReservation(array $roomReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($roomReservationArrayErrorMessage = self::validateRoomReservationForArrayConstraintsFromSetRoomReservation($roomReservation))) {
            throw new \InvalidArgumentException($roomReservationArrayErrorMessage, __LINE__);
        }
        $this->RoomReservation = $roomReservation;
        return $this;
    }
    /**
     * Add item to RoomReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomReservation $item
     * @return \StructType\ModuleReservation
     */
    public function addToRoomReservation(\StructType\RoomReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomReservation) {
            throw new \InvalidArgumentException(sprintf('The RoomReservation property can only contain items of type \StructType\RoomReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomReservation[] = $item;
        return $this;
    }
}
