<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MSG-PARAM StructType
 * @subpackage Structs
 */
class MSG_PARAM extends AbstractStructBase
{
    /**
     * The INDEX
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $INDEX;
    /**
     * The VALUE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VALUE;
    /**
     * Constructor method for MSG-PARAM
     * @uses MSG_PARAM::setINDEX()
     * @uses MSG_PARAM::setVALUE()
     * @param string $iNDEX
     * @param string $vALUE
     */
    public function __construct($iNDEX = null, $vALUE = null)
    {
        $this
            ->setINDEX($iNDEX)
            ->setVALUE($vALUE);
    }
    /**
     * Get INDEX value
     * @return string|null
     */
    public function getINDEX()
    {
        return $this->INDEX;
    }
    /**
     * Set INDEX value
     * @param string $iNDEX
     * @return \StructType\MSG_PARAM
     */
    public function setINDEX($iNDEX = null)
    {
        // validation for constraint: string
        if (!is_null($iNDEX) && !is_string($iNDEX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNDEX, true), gettype($iNDEX)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNDEX) && !preg_match('/([0-9])*/', $iNDEX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNDEX, true)), __LINE__);
        }
        $this->INDEX = $iNDEX;
        return $this;
    }
    /**
     * Get VALUE value
     * @return string|null
     */
    public function getVALUE()
    {
        return $this->VALUE;
    }
    /**
     * Set VALUE value
     * @param string $vALUE
     * @return \StructType\MSG_PARAM
     */
    public function setVALUE($vALUE = null)
    {
        // validation for constraint: string
        if (!is_null($vALUE) && !is_string($vALUE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vALUE, true), gettype($vALUE)), __LINE__);
        }
        $this->VALUE = $vALUE;
        return $this;
    }
}
