<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MSG-ENTRY StructType
 * @subpackage Structs
 */
class MSG_ENTRY extends AbstractStructBase
{
    /**
     * The MSG_LEVEL
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: INFO
     * @var string
     */
    public $MSG_LEVEL;
    /**
     * The MSG_CLASS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MSG_CLASS;
    /**
     * The MSG_NO
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $MSG_NO;
    /**
     * The MSG_TEXT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MSG_TEXT;
    /**
     * The MSG_ENTRY_PARAM_LIST
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MSG_ENTRY_PARAM_LIST
     */
    public $MSG_ENTRY_PARAM_LIST;
    /**
     * The MSG_COMMENT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MSG_COMMENT;
    /**
     * The MSG_SUPRESSED
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MSG_SUPRESSED;
    /**
     * Constructor method for MSG-ENTRY
     * @uses MSG_ENTRY::setMSG_LEVEL()
     * @uses MSG_ENTRY::setMSG_CLASS()
     * @uses MSG_ENTRY::setMSG_NO()
     * @uses MSG_ENTRY::setMSG_TEXT()
     * @uses MSG_ENTRY::setMSG_ENTRY_PARAM_LIST()
     * @uses MSG_ENTRY::setMSG_COMMENT()
     * @uses MSG_ENTRY::setMSG_SUPRESSED()
     * @param string $mSG_LEVEL
     * @param string $mSG_CLASS
     * @param string $mSG_NO
     * @param string $mSG_TEXT
     * @param \StructType\MSG_ENTRY_PARAM_LIST $mSG_ENTRY_PARAM_LIST
     * @param string $mSG_COMMENT
     * @param string $mSG_SUPRESSED
     */
    public function __construct($mSG_LEVEL = null, $mSG_CLASS = null, $mSG_NO = null, $mSG_TEXT = null, \StructType\MSG_ENTRY_PARAM_LIST $mSG_ENTRY_PARAM_LIST = null, $mSG_COMMENT = null, $mSG_SUPRESSED = null)
    {
        $this
            ->setMSG_LEVEL($mSG_LEVEL)
            ->setMSG_CLASS($mSG_CLASS)
            ->setMSG_NO($mSG_NO)
            ->setMSG_TEXT($mSG_TEXT)
            ->setMSG_ENTRY_PARAM_LIST($mSG_ENTRY_PARAM_LIST)
            ->setMSG_COMMENT($mSG_COMMENT)
            ->setMSG_SUPRESSED($mSG_SUPRESSED);
    }
    /**
     * Get MSG_LEVEL value
     * @return string|null
     */
    public function getMSG_LEVEL()
    {
        return $this->{'MSG-LEVEL'};
    }
    /**
     * Set MSG_LEVEL value
     * @param string $mSG_LEVEL
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_LEVEL($mSG_LEVEL = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_LEVEL) && !is_string($mSG_LEVEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_LEVEL, true), gettype($mSG_LEVEL)), __LINE__);
        }
        // validation for constraint: pattern(INFO)
        if (!is_null($mSG_LEVEL) && !preg_match('/INFO/', $mSG_LEVEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression INFO', var_export($mSG_LEVEL, true)), __LINE__);
        }
        $this->MSG_LEVEL = $this->{'MSG-LEVEL'} = $mSG_LEVEL;
        return $this;
    }
    /**
     * Get MSG_CLASS value
     * @return string|null
     */
    public function getMSG_CLASS()
    {
        return $this->{'MSG-CLASS'};
    }
    /**
     * Set MSG_CLASS value
     * @param string $mSG_CLASS
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_CLASS($mSG_CLASS = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_CLASS) && !is_string($mSG_CLASS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_CLASS, true), gettype($mSG_CLASS)), __LINE__);
        }
        $this->MSG_CLASS = $this->{'MSG-CLASS'} = $mSG_CLASS;
        return $this;
    }
    /**
     * Get MSG_NO value
     * @return string|null
     */
    public function getMSG_NO()
    {
        return $this->{'MSG-NO'};
    }
    /**
     * Set MSG_NO value
     * @param string $mSG_NO
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_NO($mSG_NO = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_NO) && !is_string($mSG_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_NO, true), gettype($mSG_NO)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($mSG_NO) && !preg_match('/([0-9])*/', $mSG_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($mSG_NO, true)), __LINE__);
        }
        $this->MSG_NO = $this->{'MSG-NO'} = $mSG_NO;
        return $this;
    }
    /**
     * Get MSG_TEXT value
     * @return string|null
     */
    public function getMSG_TEXT()
    {
        return $this->{'MSG-TEXT'};
    }
    /**
     * Set MSG_TEXT value
     * @param string $mSG_TEXT
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_TEXT($mSG_TEXT = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_TEXT) && !is_string($mSG_TEXT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_TEXT, true), gettype($mSG_TEXT)), __LINE__);
        }
        $this->MSG_TEXT = $this->{'MSG-TEXT'} = $mSG_TEXT;
        return $this;
    }
    /**
     * Get MSG_ENTRY_PARAM_LIST value
     * @return \StructType\MSG_ENTRY_PARAM_LIST|null
     */
    public function getMSG_ENTRY_PARAM_LIST()
    {
        return $this->{'MSG-ENTRY-PARAM-LIST'};
    }
    /**
     * Set MSG_ENTRY_PARAM_LIST value
     * @param \StructType\MSG_ENTRY_PARAM_LIST $mSG_ENTRY_PARAM_LIST
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_ENTRY_PARAM_LIST(\StructType\MSG_ENTRY_PARAM_LIST $mSG_ENTRY_PARAM_LIST = null)
    {
        $this->MSG_ENTRY_PARAM_LIST = $this->{'MSG-ENTRY-PARAM-LIST'} = $mSG_ENTRY_PARAM_LIST;
        return $this;
    }
    /**
     * Get MSG_COMMENT value
     * @return string|null
     */
    public function getMSG_COMMENT()
    {
        return $this->{'MSG-COMMENT'};
    }
    /**
     * Set MSG_COMMENT value
     * @param string $mSG_COMMENT
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_COMMENT($mSG_COMMENT = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_COMMENT) && !is_string($mSG_COMMENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_COMMENT, true), gettype($mSG_COMMENT)), __LINE__);
        }
        $this->MSG_COMMENT = $this->{'MSG-COMMENT'} = $mSG_COMMENT;
        return $this;
    }
    /**
     * Get MSG_SUPRESSED value
     * @return string|null
     */
    public function getMSG_SUPRESSED()
    {
        return $this->{'MSG-SUPRESSED'};
    }
    /**
     * Set MSG_SUPRESSED value
     * @param string $mSG_SUPRESSED
     * @return \StructType\MSG_ENTRY
     */
    public function setMSG_SUPRESSED($mSG_SUPRESSED = null)
    {
        // validation for constraint: string
        if (!is_null($mSG_SUPRESSED) && !is_string($mSG_SUPRESSED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSG_SUPRESSED, true), gettype($mSG_SUPRESSED)), __LINE__);
        }
        $this->MSG_SUPRESSED = $this->{'MSG-SUPRESSED'} = $mSG_SUPRESSED;
        return $this;
    }
}
