<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MAINACCOUNT StructType
 * @subpackage Structs
 */
class MAINACCOUNT_1 extends AbstractStructBase
{
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * The accountno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $accountno;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * Constructor method for MAINACCOUNT
     * @uses MAINACCOUNT_1::setACCOUNT_OBJID()
     * @uses MAINACCOUNT_1::setAccounttype()
     * @uses MAINACCOUNT_1::setAccountno()
     * @uses MAINACCOUNT_1::setArrival()
     * @uses MAINACCOUNT_1::setDeparture()
     * @param string $aCCOUNT_OBJID
     * @param string $accounttype
     * @param string $accountno
     * @param string $arrival
     * @param string $departure
     */
    public function __construct($aCCOUNT_OBJID = null, $accounttype = null, $accountno = null, $arrival = null, $departure = null)
    {
        $this
            ->setACCOUNT_OBJID($aCCOUNT_OBJID)
            ->setAccounttype($accounttype)
            ->setAccountno($accountno)
            ->setArrival($arrival)
            ->setDeparture($departure);
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\MAINACCOUNT_1
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\MAINACCOUNT_1
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get accountno value
     * @return string
     */
    public function getAccountno()
    {
        return $this->accountno;
    }
    /**
     * Set accountno value
     * @param string $accountno
     * @return \StructType\MAINACCOUNT_1
     */
    public function setAccountno($accountno = null)
    {
        // validation for constraint: string
        if (!is_null($accountno) && !is_string($accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountno, true), gettype($accountno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($accountno) && !preg_match('/([-+]){0,1}([0-9])*/', $accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($accountno, true)), __LINE__);
        }
        $this->accountno = $accountno;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\MAINACCOUNT_1
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\MAINACCOUNT_1
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
}
