<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LOYALTY-CARD StructType
 * @subpackage Structs
 */
class LOYALTY_CARD extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The level
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $level;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The validuntil
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $validuntil;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The cardtext
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $cardtext;
    /**
     * The validfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $validfrom;
    /**
     * The LOYALTY_CARD_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $LOYALTY_CARD_OBJID;
    /**
     * The statusreason
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $statusreason;
    /**
     * The stakeholder
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $stakeholder;
    /**
     * Constructor method for LOYALTY-CARD
     * @uses LOYALTY_CARD::setType()
     * @uses LOYALTY_CARD::setLevel()
     * @uses LOYALTY_CARD::setNumber()
     * @uses LOYALTY_CARD::setValiduntil()
     * @uses LOYALTY_CARD::setStatus()
     * @uses LOYALTY_CARD::setExternalreference()
     * @uses LOYALTY_CARD::setCardtext()
     * @uses LOYALTY_CARD::setValidfrom()
     * @uses LOYALTY_CARD::setLOYALTY_CARD_OBJID()
     * @uses LOYALTY_CARD::setStatusreason()
     * @uses LOYALTY_CARD::setStakeholder()
     * @param string $type
     * @param string $level
     * @param string $number
     * @param string $validuntil
     * @param string $status
     * @param string $externalreference
     * @param string $cardtext
     * @param string $validfrom
     * @param string $lOYALTY_CARD_OBJID
     * @param string $statusreason
     * @param string $stakeholder
     */
    public function __construct($type = null, $level = null, $number = null, $validuntil = null, $status = null, $externalreference = null, $cardtext = null, $validfrom = null, $lOYALTY_CARD_OBJID = null, $statusreason = null, $stakeholder = null)
    {
        $this
            ->setType($type)
            ->setLevel($level)
            ->setNumber($number)
            ->setValiduntil($validuntil)
            ->setStatus($status)
            ->setExternalreference($externalreference)
            ->setCardtext($cardtext)
            ->setValidfrom($validfrom)
            ->setLOYALTY_CARD_OBJID($lOYALTY_CARD_OBJID)
            ->setStatusreason($statusreason)
            ->setStakeholder($stakeholder);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\LOYALTY_CARD
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type) && mb_strlen($type) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get level value
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param string $level
     * @return \StructType\LOYALTY_CARD
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($level) && mb_strlen($level) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($level)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($level) && mb_strlen($level) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($level)), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\LOYALTY_CARD
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get validuntil value
     * @return string
     */
    public function getValiduntil()
    {
        return $this->validuntil;
    }
    /**
     * Set validuntil value
     * @param string $validuntil
     * @return \StructType\LOYALTY_CARD
     */
    public function setValiduntil($validuntil = null)
    {
        // validation for constraint: string
        if (!is_null($validuntil) && !is_string($validuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validuntil, true), gettype($validuntil)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($validuntil) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $validuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($validuntil, true)), __LINE__);
        }
        $this->validuntil = $validuntil;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\LOYALTY_CARD
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\LOYALTY_CARD
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get cardtext value
     * @return string
     */
    public function getCardtext()
    {
        return $this->cardtext;
    }
    /**
     * Set cardtext value
     * @param string $cardtext
     * @return \StructType\LOYALTY_CARD
     */
    public function setCardtext($cardtext = null)
    {
        // validation for constraint: string
        if (!is_null($cardtext) && !is_string($cardtext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardtext, true), gettype($cardtext)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cardtext) && mb_strlen($cardtext) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cardtext)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cardtext) && mb_strlen($cardtext) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cardtext)), __LINE__);
        }
        $this->cardtext = $cardtext;
        return $this;
    }
    /**
     * Get validfrom value
     * @return string
     */
    public function getValidfrom()
    {
        return $this->validfrom;
    }
    /**
     * Set validfrom value
     * @param string $validfrom
     * @return \StructType\LOYALTY_CARD
     */
    public function setValidfrom($validfrom = null)
    {
        // validation for constraint: string
        if (!is_null($validfrom) && !is_string($validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validfrom, true), gettype($validfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($validfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($validfrom, true)), __LINE__);
        }
        $this->validfrom = $validfrom;
        return $this;
    }
    /**
     * Get LOYALTY_CARD_OBJID value
     * @return string
     */
    public function getLOYALTY_CARD_OBJID()
    {
        return $this->{'LOYALTY-CARD-OBJID'};
    }
    /**
     * Set LOYALTY_CARD_OBJID value
     * @param string $lOYALTY_CARD_OBJID
     * @return \StructType\LOYALTY_CARD
     */
    public function setLOYALTY_CARD_OBJID($lOYALTY_CARD_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($lOYALTY_CARD_OBJID) && !is_string($lOYALTY_CARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOYALTY_CARD_OBJID, true), gettype($lOYALTY_CARD_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($lOYALTY_CARD_OBJID) && !preg_match('/([0-9])*/', $lOYALTY_CARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($lOYALTY_CARD_OBJID, true)), __LINE__);
        }
        $this->LOYALTY_CARD_OBJID = $this->{'LOYALTY-CARD-OBJID'} = $lOYALTY_CARD_OBJID;
        return $this;
    }
    /**
     * Get statusreason value
     * @return string|null
     */
    public function getStatusreason()
    {
        return $this->statusreason;
    }
    /**
     * Set statusreason value
     * @param string $statusreason
     * @return \StructType\LOYALTY_CARD
     */
    public function setStatusreason($statusreason = null)
    {
        // validation for constraint: string
        if (!is_null($statusreason) && !is_string($statusreason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusreason, true), gettype($statusreason)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($statusreason) && mb_strlen($statusreason) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($statusreason)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($statusreason) && mb_strlen($statusreason) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($statusreason)), __LINE__);
        }
        $this->statusreason = $statusreason;
        return $this;
    }
    /**
     * Get stakeholder value
     * @return string|null
     */
    public function getStakeholder()
    {
        return $this->stakeholder;
    }
    /**
     * Set stakeholder value
     * @param string $stakeholder
     * @return \StructType\LOYALTY_CARD
     */
    public function setStakeholder($stakeholder = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholder) && !is_string($stakeholder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholder, true), gettype($stakeholder)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($stakeholder) && mb_strlen($stakeholder) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($stakeholder)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($stakeholder) && mb_strlen($stakeholder) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($stakeholder)), __LINE__);
        }
        $this->stakeholder = $stakeholder;
        return $this;
    }
}
