<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LANGUAGE-COMMENT StructType
 * @subpackage Structs
 */
class LANGUAGE_COMMENT extends AbstractStructBase
{
    /**
     * The languagecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $languagecode;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for LANGUAGE-COMMENT
     * @uses LANGUAGE_COMMENT::setLanguagecode()
     * @uses LANGUAGE_COMMENT::setLanguage()
     * @uses LANGUAGE_COMMENT::setComment()
     * @param string $languagecode
     * @param string $language
     * @param string $comment
     */
    public function __construct($languagecode = null, $language = null, $comment = null)
    {
        $this
            ->setLanguagecode($languagecode)
            ->setLanguage($language)
            ->setComment($comment);
    }
    /**
     * Get languagecode value
     * @return string|null
     */
    public function getLanguagecode()
    {
        return $this->languagecode;
    }
    /**
     * Set languagecode value
     * @param string $languagecode
     * @return \StructType\LANGUAGE_COMMENT
     */
    public function setLanguagecode($languagecode = null)
    {
        // validation for constraint: string
        if (!is_null($languagecode) && !is_string($languagecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languagecode, true), gettype($languagecode)), __LINE__);
        }
        $this->languagecode = $languagecode;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\LANGUAGE_COMMENT
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\LANGUAGE_COMMENT
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
