<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicedPostings StructType
 * @subpackage Structs
 */
class InvoicedPostings extends AbstractStructBase
{
    /**
     * The InvoicedPosting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoicedPosting[]
     */
    public $InvoicedPosting;
    /**
     * Constructor method for InvoicedPostings
     * @uses InvoicedPostings::setInvoicedPosting()
     * @param \StructType\InvoicedPosting[] $invoicedPosting
     */
    public function __construct(array $invoicedPosting = array())
    {
        $this
            ->setInvoicedPosting($invoicedPosting);
    }
    /**
     * Get InvoicedPosting value
     * @return \StructType\InvoicedPosting[]|null
     */
    public function getInvoicedPosting()
    {
        return $this->InvoicedPosting;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicedPosting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicedPosting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicedPostingForArrayConstraintsFromSetInvoicedPosting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoicedPostingsInvoicedPostingItem) {
            // validation for constraint: itemType
            if (!$invoicedPostingsInvoicedPostingItem instanceof \StructType\InvoicedPosting) {
                $invalidValues[] = is_object($invoicedPostingsInvoicedPostingItem) ? get_class($invoicedPostingsInvoicedPostingItem) : sprintf('%s(%s)', gettype($invoicedPostingsInvoicedPostingItem), var_export($invoicedPostingsInvoicedPostingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicedPosting property can only contain items of type \StructType\InvoicedPosting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicedPosting value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPosting[] $invoicedPosting
     * @return \StructType\InvoicedPostings
     */
    public function setInvoicedPosting(array $invoicedPosting = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicedPostingArrayErrorMessage = self::validateInvoicedPostingForArrayConstraintsFromSetInvoicedPosting($invoicedPosting))) {
            throw new \InvalidArgumentException($invoicedPostingArrayErrorMessage, __LINE__);
        }
        $this->InvoicedPosting = $invoicedPosting;
        return $this;
    }
    /**
     * Add item to InvoicedPosting value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPosting $item
     * @return \StructType\InvoicedPostings
     */
    public function addToInvoicedPosting(\StructType\InvoicedPosting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicedPosting) {
            throw new \InvalidArgumentException(sprintf('The InvoicedPosting property can only contain items of type \StructType\InvoicedPosting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicedPosting[] = $item;
        return $this;
    }
}
