<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICEHOLDER StructType
 * @subpackage Structs
 */
class INVOICEHOLDER_1 extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutation;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The pobox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pobox;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identificationNo;
    /**
     * The documentnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentnumber;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documenttype;
    /**
     * The documentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $documentdate;
    /**
     * The taxnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $taxnumber;
    /**
     * The taxnumber2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $taxnumber2;
    /**
     * The taxnumber3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $taxnumber3;
    /**
     * The GUEST_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_CENTRALID;
    /**
     * Constructor method for INVOICEHOLDER
     * @uses INVOICEHOLDER_1::setGUEST_OBJID()
     * @uses INVOICEHOLDER_1::setSalutation()
     * @uses INVOICEHOLDER_1::setLastName()
     * @uses INVOICEHOLDER_1::setFirstName()
     * @uses INVOICEHOLDER_1::setGuestType()
     * @uses INVOICEHOLDER_1::setCountry()
     * @uses INVOICEHOLDER_1::setCity()
     * @uses INVOICEHOLDER_1::setPobox()
     * @uses INVOICEHOLDER_1::setPostcode()
     * @uses INVOICEHOLDER_1::setStreet()
     * @uses INVOICEHOLDER_1::setGuestHotel()
     * @uses INVOICEHOLDER_1::setGuestNo()
     * @uses INVOICEHOLDER_1::setIdentificationNo()
     * @uses INVOICEHOLDER_1::setDocumentnumber()
     * @uses INVOICEHOLDER_1::setDocumenttype()
     * @uses INVOICEHOLDER_1::setDocumentdate()
     * @uses INVOICEHOLDER_1::setTaxnumber()
     * @uses INVOICEHOLDER_1::setTaxnumber2()
     * @uses INVOICEHOLDER_1::setTaxnumber3()
     * @uses INVOICEHOLDER_1::setGUEST_CENTRALID()
     * @param string $gUEST_OBJID
     * @param string $salutation
     * @param string $lastName
     * @param string $firstName
     * @param string $guestType
     * @param string $country
     * @param string $city
     * @param string $pobox
     * @param string $postcode
     * @param string $street
     * @param string $guestHotel
     * @param string $guestNo
     * @param string $identificationNo
     * @param string $documentnumber
     * @param string $documenttype
     * @param string $documentdate
     * @param string $taxnumber
     * @param string $taxnumber2
     * @param string $taxnumber3
     * @param string $gUEST_CENTRALID
     */
    public function __construct($gUEST_OBJID = null, $salutation = null, $lastName = null, $firstName = null, $guestType = null, $country = null, $city = null, $pobox = null, $postcode = null, $street = null, $guestHotel = null, $guestNo = null, $identificationNo = null, $documentnumber = null, $documenttype = null, $documentdate = null, $taxnumber = null, $taxnumber2 = null, $taxnumber3 = null, $gUEST_CENTRALID = null)
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setSalutation($salutation)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setGuestType($guestType)
            ->setCountry($country)
            ->setCity($city)
            ->setPobox($pobox)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo)
            ->setIdentificationNo($identificationNo)
            ->setDocumentnumber($documentnumber)
            ->setDocumenttype($documenttype)
            ->setDocumentdate($documentdate)
            ->setTaxnumber($taxnumber)
            ->setTaxnumber2($taxnumber2)
            ->setTaxnumber3($taxnumber3)
            ->setGUEST_CENTRALID($gUEST_CENTRALID);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get salutation value
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get pobox value
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }
    /**
     * Set pobox value
     * @param string $pobox
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setPobox($pobox = null)
    {
        // validation for constraint: string
        if (!is_null($pobox) && !is_string($pobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pobox, true), gettype($pobox)), __LINE__);
        }
        $this->pobox = $pobox;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get documentnumber value
     * @return string
     */
    public function getDocumentnumber()
    {
        return $this->documentnumber;
    }
    /**
     * Set documentnumber value
     * @param string $documentnumber
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setDocumentnumber($documentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentnumber) && !is_string($documentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnumber, true), gettype($documentnumber)), __LINE__);
        }
        $this->documentnumber = $documentnumber;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentdate value
     * @return string
     */
    public function getDocumentdate()
    {
        return $this->documentdate;
    }
    /**
     * Set documentdate value
     * @param string $documentdate
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setDocumentdate($documentdate = null)
    {
        // validation for constraint: string
        if (!is_null($documentdate) && !is_string($documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentdate, true), gettype($documentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($documentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($documentdate, true)), __LINE__);
        }
        $this->documentdate = $documentdate;
        return $this;
    }
    /**
     * Get taxnumber value
     * @return string
     */
    public function getTaxnumber()
    {
        return $this->taxnumber;
    }
    /**
     * Set taxnumber value
     * @param string $taxnumber
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setTaxnumber($taxnumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber) && !is_string($taxnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber, true), gettype($taxnumber)), __LINE__);
        }
        $this->taxnumber = $taxnumber;
        return $this;
    }
    /**
     * Get taxnumber2 value
     * @return string
     */
    public function getTaxnumber2()
    {
        return $this->taxnumber2;
    }
    /**
     * Set taxnumber2 value
     * @param string $taxnumber2
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setTaxnumber2($taxnumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber2) && !is_string($taxnumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber2, true), gettype($taxnumber2)), __LINE__);
        }
        $this->taxnumber2 = $taxnumber2;
        return $this;
    }
    /**
     * Get taxnumber3 value
     * @return string
     */
    public function getTaxnumber3()
    {
        return $this->taxnumber3;
    }
    /**
     * Set taxnumber3 value
     * @param string $taxnumber3
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setTaxnumber3($taxnumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber3) && !is_string($taxnumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber3, true), gettype($taxnumber3)), __LINE__);
        }
        $this->taxnumber3 = $taxnumber3;
        return $this;
    }
    /**
     * Get GUEST_CENTRALID value
     * @return string
     */
    public function getGUEST_CENTRALID()
    {
        return $this->{'GUEST-CENTRALID'};
    }
    /**
     * Set GUEST_CENTRALID value
     * @param string $gUEST_CENTRALID
     * @return \StructType\INVOICEHOLDER_1
     */
    public function setGUEST_CENTRALID($gUEST_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_CENTRALID) && !is_string($gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_CENTRALID, true), gettype($gUEST_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_CENTRALID) && !preg_match('/([0-9])*/', $gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_CENTRALID, true)), __LINE__);
        }
        $this->GUEST_CENTRALID = $this->{'GUEST-CENTRALID'} = $gUEST_CENTRALID;
        return $this;
    }
}
