<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IMAGE StructType
 * @subpackage Structs
 */
class IMAGE_1 extends AbstractStructBase
{
    /**
     * The IMAGE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $IMAGE_OBJID;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $image;
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $filename;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The sorting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sorting;
    /**
     * The filesize
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $filesize;
    /**
     * Constructor method for IMAGE
     * @uses IMAGE_1::setIMAGE_OBJID()
     * @uses IMAGE_1::setImage()
     * @uses IMAGE_1::setFilename()
     * @uses IMAGE_1::setDescription()
     * @uses IMAGE_1::setSorting()
     * @uses IMAGE_1::setFilesize()
     * @param string $iMAGE_OBJID
     * @param string $image
     * @param string $filename
     * @param string $description
     * @param string $sorting
     * @param string $filesize
     */
    public function __construct($iMAGE_OBJID = null, $image = null, $filename = null, $description = null, $sorting = null, $filesize = null)
    {
        $this
            ->setIMAGE_OBJID($iMAGE_OBJID)
            ->setImage($image)
            ->setFilename($filename)
            ->setDescription($description)
            ->setSorting($sorting)
            ->setFilesize($filesize);
    }
    /**
     * Get IMAGE_OBJID value
     * @return string
     */
    public function getIMAGE_OBJID()
    {
        return $this->{'IMAGE-OBJID'};
    }
    /**
     * Set IMAGE_OBJID value
     * @param string $iMAGE_OBJID
     * @return \StructType\IMAGE_1
     */
    public function setIMAGE_OBJID($iMAGE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iMAGE_OBJID) && !is_string($iMAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iMAGE_OBJID, true), gettype($iMAGE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iMAGE_OBJID) && !preg_match('/([0-9])*/', $iMAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iMAGE_OBJID, true)), __LINE__);
        }
        $this->IMAGE_OBJID = $this->{'IMAGE-OBJID'} = $iMAGE_OBJID;
        return $this;
    }
    /**
     * Get image value
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \StructType\IMAGE_1
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get filename value
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\IMAGE_1
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\IMAGE_1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get sorting value
     * @return string
     */
    public function getSorting()
    {
        return $this->sorting;
    }
    /**
     * Set sorting value
     * @param string $sorting
     * @return \StructType\IMAGE_1
     */
    public function setSorting($sorting = null)
    {
        // validation for constraint: string
        if (!is_null($sorting) && !is_string($sorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sorting, true), gettype($sorting)), __LINE__);
        }
        $this->sorting = $sorting;
        return $this;
    }
    /**
     * Get filesize value
     * @return string
     */
    public function getFilesize()
    {
        return $this->filesize;
    }
    /**
     * Set filesize value
     * @param string $filesize
     * @return \StructType\IMAGE_1
     */
    public function setFilesize($filesize = null)
    {
        // validation for constraint: string
        if (!is_null($filesize) && !is_string($filesize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filesize, true), gettype($filesize)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($filesize) && !preg_match('/([-+]){0,1}([0-9])*/', $filesize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($filesize, true)), __LINE__);
        }
        $this->filesize = $filesize;
        return $this;
    }
}
