<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IMAGES StructType
 * @subpackage Structs
 */
class IMAGES_1 extends AbstractStructBase
{
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The reftablename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $reftablename;
    /**
     * The IMAGE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IMAGE_1[]
     */
    public $IMAGE;
    /**
     * Constructor method for IMAGES
     * @uses IMAGES_1::setRefobjid()
     * @uses IMAGES_1::setReftablename()
     * @uses IMAGES_1::setIMAGE()
     * @param string $refobjid
     * @param string $reftablename
     * @param \StructType\IMAGE_1[] $iMAGE
     */
    public function __construct($refobjid = null, $reftablename = null, array $iMAGE = array())
    {
        $this
            ->setRefobjid($refobjid)
            ->setReftablename($reftablename)
            ->setIMAGE($iMAGE);
    }
    /**
     * Get refobjid value
     * @return string
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\IMAGES_1
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get reftablename value
     * @return string
     */
    public function getReftablename()
    {
        return $this->reftablename;
    }
    /**
     * Set reftablename value
     * @param string $reftablename
     * @return \StructType\IMAGES_1
     */
    public function setReftablename($reftablename = null)
    {
        // validation for constraint: string
        if (!is_null($reftablename) && !is_string($reftablename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reftablename, true), gettype($reftablename)), __LINE__);
        }
        $this->reftablename = $reftablename;
        return $this;
    }
    /**
     * Get IMAGE value
     * @return \StructType\IMAGE_1[]|null
     */
    public function getIMAGE()
    {
        return $this->IMAGE;
    }
    /**
     * This method is responsible for validating the values passed to the setIMAGE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIMAGE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIMAGEForArrayConstraintsFromSetIMAGE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iMAGESIMAGEItem) {
            // validation for constraint: itemType
            if (!$iMAGESIMAGEItem instanceof \StructType\IMAGE_1) {
                $invalidValues[] = is_object($iMAGESIMAGEItem) ? get_class($iMAGESIMAGEItem) : sprintf('%s(%s)', gettype($iMAGESIMAGEItem), var_export($iMAGESIMAGEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IMAGE property can only contain items of type \StructType\IMAGE_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IMAGE value
     * @throws \InvalidArgumentException
     * @param \StructType\IMAGE_1[] $iMAGE
     * @return \StructType\IMAGES_1
     */
    public function setIMAGE(array $iMAGE = array())
    {
        // validation for constraint: array
        if ('' !== ($iMAGEArrayErrorMessage = self::validateIMAGEForArrayConstraintsFromSetIMAGE($iMAGE))) {
            throw new \InvalidArgumentException($iMAGEArrayErrorMessage, __LINE__);
        }
        $this->IMAGE = $iMAGE;
        return $this;
    }
    /**
     * Add item to IMAGE value
     * @throws \InvalidArgumentException
     * @param \StructType\IMAGE_1 $item
     * @return \StructType\IMAGES_1
     */
    public function addToIMAGE(\StructType\IMAGE_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IMAGE_1) {
            throw new \InvalidArgumentException(sprintf('The IMAGE property can only contain items of type \StructType\IMAGE_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IMAGE[] = $item;
        return $this;
    }
}
