<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest StructType
 * @subpackage Structs
 */
class Guest_1 extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The GUEST_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_CENTRALID;
    /**
     * The documentnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 44
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $documentnumber;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $documenttype;
    /**
     * The documentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $documentdate;
    /**
     * The docissuingcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $docissuingcountry;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The location2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $location2;
    /**
     * The savecontactdata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $savecontactdata;
    /**
     * The phone1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone1;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The GST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GST_OBJID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The pobox
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $pobox;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $identificationNo;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The salutcorrespond
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutcorrespond;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The phone2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone2;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $fax;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip;
    /**
     * The vip2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip2;
    /**
     * The gsttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $gsttype;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nationality;
    /**
     * The profession
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $profession;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The placeofbirth
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $placeofbirth;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $birthcountry;
    /**
     * The licenceplatenumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $licenceplatenumber;
    /**
     * The docissuedat
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $docissuedat;
    /**
     * The docexpirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $docexpirydate;
    /**
     * The EXTERNALID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EXTERNALID[]
     */
    public $EXTERNALID;
    /**
     * Constructor method for Guest
     * @uses Guest_1::setGUEST_OBJID()
     * @uses Guest_1::setGUEST_CENTRALID()
     * @uses Guest_1::setDocumentnumber()
     * @uses Guest_1::setDocumenttype()
     * @uses Guest_1::setDocumentdate()
     * @uses Guest_1::setDocissuingcountry()
     * @uses Guest_1::setLanguage()
     * @uses Guest_1::setLocation2()
     * @uses Guest_1::setSavecontactdata()
     * @uses Guest_1::setPhone1()
     * @uses Guest_1::setMatchcode()
     * @uses Guest_1::setGST_OBJID()
     * @uses Guest_1::setAddress()
     * @uses Guest_1::setLastName()
     * @uses Guest_1::setFirstName()
     * @uses Guest_1::setGuestType()
     * @uses Guest_1::setCountry()
     * @uses Guest_1::setSubcountry()
     * @uses Guest_1::setSubsubcountry()
     * @uses Guest_1::setCity()
     * @uses Guest_1::setPobox()
     * @uses Guest_1::setPostcode()
     * @uses Guest_1::setStreet()
     * @uses Guest_1::setEmail()
     * @uses Guest_1::setGuestHotel()
     * @uses Guest_1::setGuestNo()
     * @uses Guest_1::setIdentificationNo()
     * @uses Guest_1::setBirthdate()
     * @uses Guest_1::setRatesegment()
     * @uses Guest_1::setMarketsegment()
     * @uses Guest_1::setSalutcorrespond()
     * @uses Guest_1::setPhone()
     * @uses Guest_1::setPhone2()
     * @uses Guest_1::setMobile1()
     * @uses Guest_1::setFax()
     * @uses Guest_1::setCentralid()
     * @uses Guest_1::setVip()
     * @uses Guest_1::setVip2()
     * @uses Guest_1::setGsttype()
     * @uses Guest_1::setName1()
     * @uses Guest_1::setName2()
     * @uses Guest_1::setRegion()
     * @uses Guest_1::setNationality()
     * @uses Guest_1::setProfession()
     * @uses Guest_1::setEmail1()
     * @uses Guest_1::setPlaceofbirth()
     * @uses Guest_1::setBirthcountry()
     * @uses Guest_1::setLicenceplatenumber()
     * @uses Guest_1::setDocissuedat()
     * @uses Guest_1::setDocexpirydate()
     * @uses Guest_1::setEXTERNALID()
     * @param string $gUEST_OBJID
     * @param string $gUEST_CENTRALID
     * @param string $documentnumber
     * @param string $documenttype
     * @param string $documentdate
     * @param string $docissuingcountry
     * @param string $language
     * @param string $location2
     * @param string $savecontactdata
     * @param string $phone1
     * @param string $matchcode
     * @param string $gST_OBJID
     * @param string $address
     * @param string $lastName
     * @param string $firstName
     * @param string $guestType
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $city
     * @param string $pobox
     * @param string $postcode
     * @param string $street
     * @param string $email
     * @param string $guestHotel
     * @param string $guestNo
     * @param string $identificationNo
     * @param string $birthdate
     * @param string $ratesegment
     * @param string $marketsegment
     * @param string $salutcorrespond
     * @param string $phone
     * @param string $phone2
     * @param string $mobile1
     * @param string $fax
     * @param string $centralid
     * @param string $vip
     * @param string $vip2
     * @param string $gsttype
     * @param string $name1
     * @param string $name2
     * @param string $region
     * @param string $nationality
     * @param string $profession
     * @param string $email1
     * @param string $placeofbirth
     * @param string $birthcountry
     * @param string $licenceplatenumber
     * @param string $docissuedat
     * @param string $docexpirydate
     * @param \StructType\EXTERNALID[] $eXTERNALID
     */
    public function __construct($gUEST_OBJID = null, $gUEST_CENTRALID = null, $documentnumber = null, $documenttype = null, $documentdate = null, $docissuingcountry = null, $language = null, $location2 = null, $savecontactdata = null, $phone1 = null, $matchcode = null, $gST_OBJID = null, $address = null, $lastName = null, $firstName = null, $guestType = null, $country = null, $subcountry = null, $subsubcountry = null, $city = null, $pobox = null, $postcode = null, $street = null, $email = null, $guestHotel = null, $guestNo = null, $identificationNo = null, $birthdate = null, $ratesegment = null, $marketsegment = null, $salutcorrespond = null, $phone = null, $phone2 = null, $mobile1 = null, $fax = null, $centralid = null, $vip = null, $vip2 = null, $gsttype = null, $name1 = null, $name2 = null, $region = null, $nationality = null, $profession = null, $email1 = null, $placeofbirth = null, $birthcountry = null, $licenceplatenumber = null, $docissuedat = null, $docexpirydate = null, array $eXTERNALID = array())
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setGUEST_CENTRALID($gUEST_CENTRALID)
            ->setDocumentnumber($documentnumber)
            ->setDocumenttype($documenttype)
            ->setDocumentdate($documentdate)
            ->setDocissuingcountry($docissuingcountry)
            ->setLanguage($language)
            ->setLocation2($location2)
            ->setSavecontactdata($savecontactdata)
            ->setPhone1($phone1)
            ->setMatchcode($matchcode)
            ->setGST_OBJID($gST_OBJID)
            ->setAddress($address)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setGuestType($guestType)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setCity($city)
            ->setPobox($pobox)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setEmail($email)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo)
            ->setIdentificationNo($identificationNo)
            ->setBirthdate($birthdate)
            ->setRatesegment($ratesegment)
            ->setMarketsegment($marketsegment)
            ->setSalutcorrespond($salutcorrespond)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setMobile1($mobile1)
            ->setFax($fax)
            ->setCentralid($centralid)
            ->setVip($vip)
            ->setVip2($vip2)
            ->setGsttype($gsttype)
            ->setName1($name1)
            ->setName2($name2)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setProfession($profession)
            ->setEmail1($email1)
            ->setPlaceofbirth($placeofbirth)
            ->setBirthcountry($birthcountry)
            ->setLicenceplatenumber($licenceplatenumber)
            ->setDocissuedat($docissuedat)
            ->setDocexpirydate($docexpirydate)
            ->setEXTERNALID($eXTERNALID);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\Guest_1
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get GUEST_CENTRALID value
     * @return string
     */
    public function getGUEST_CENTRALID()
    {
        return $this->{'GUEST-CENTRALID'};
    }
    /**
     * Set GUEST_CENTRALID value
     * @param string $gUEST_CENTRALID
     * @return \StructType\Guest_1
     */
    public function setGUEST_CENTRALID($gUEST_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_CENTRALID) && !is_string($gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_CENTRALID, true), gettype($gUEST_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_CENTRALID) && !preg_match('/([0-9])*/', $gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_CENTRALID, true)), __LINE__);
        }
        $this->GUEST_CENTRALID = $this->{'GUEST-CENTRALID'} = $gUEST_CENTRALID;
        return $this;
    }
    /**
     * Get documentnumber value
     * @return string
     */
    public function getDocumentnumber()
    {
        return $this->documentnumber;
    }
    /**
     * Set documentnumber value
     * @param string $documentnumber
     * @return \StructType\Guest_1
     */
    public function setDocumentnumber($documentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentnumber) && !is_string($documentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnumber, true), gettype($documentnumber)), __LINE__);
        }
        // validation for constraint: maxLength(44)
        if (!is_null($documentnumber) && mb_strlen($documentnumber) > 44) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 44', mb_strlen($documentnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documentnumber) && mb_strlen($documentnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documentnumber)), __LINE__);
        }
        $this->documentnumber = $documentnumber;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \StructType\Guest_1
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($documenttype) && mb_strlen($documenttype) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($documenttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documenttype) && mb_strlen($documenttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentdate value
     * @return string
     */
    public function getDocumentdate()
    {
        return $this->documentdate;
    }
    /**
     * Set documentdate value
     * @param string $documentdate
     * @return \StructType\Guest_1
     */
    public function setDocumentdate($documentdate = null)
    {
        // validation for constraint: string
        if (!is_null($documentdate) && !is_string($documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentdate, true), gettype($documentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($documentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($documentdate, true)), __LINE__);
        }
        $this->documentdate = $documentdate;
        return $this;
    }
    /**
     * Get docissuingcountry value
     * @return string
     */
    public function getDocissuingcountry()
    {
        return $this->docissuingcountry;
    }
    /**
     * Set docissuingcountry value
     * @param string $docissuingcountry
     * @return \StructType\Guest_1
     */
    public function setDocissuingcountry($docissuingcountry = null)
    {
        // validation for constraint: string
        if (!is_null($docissuingcountry) && !is_string($docissuingcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuingcountry, true), gettype($docissuingcountry)), __LINE__);
        }
        $this->docissuingcountry = $docissuingcountry;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Guest_1
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get location2 value
     * @return string
     */
    public function getLocation2()
    {
        return $this->location2;
    }
    /**
     * Set location2 value
     * @param string $location2
     * @return \StructType\Guest_1
     */
    public function setLocation2($location2 = null)
    {
        // validation for constraint: string
        if (!is_null($location2) && !is_string($location2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location2, true), gettype($location2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($location2) && mb_strlen($location2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($location2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location2) && mb_strlen($location2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location2)), __LINE__);
        }
        $this->location2 = $location2;
        return $this;
    }
    /**
     * Get savecontactdata value
     * @return string
     */
    public function getSavecontactdata()
    {
        return $this->savecontactdata;
    }
    /**
     * Set savecontactdata value
     * @param string $savecontactdata
     * @return \StructType\Guest_1
     */
    public function setSavecontactdata($savecontactdata = null)
    {
        // validation for constraint: string
        if (!is_null($savecontactdata) && !is_string($savecontactdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savecontactdata, true), gettype($savecontactdata)), __LINE__);
        }
        $this->savecontactdata = $savecontactdata;
        return $this;
    }
    /**
     * Get phone1 value
     * @return string
     */
    public function getPhone1()
    {
        return $this->phone1;
    }
    /**
     * Set phone1 value
     * @param string $phone1
     * @return \StructType\Guest_1
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone1) && mb_strlen($phone1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone1) && mb_strlen($phone1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone1)), __LINE__);
        }
        $this->phone1 = $phone1;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\Guest_1
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get GST_OBJID value
     * @return string
     */
    public function getGST_OBJID()
    {
        return $this->{'GST-OBJID'};
    }
    /**
     * Set GST_OBJID value
     * @param string $gST_OBJID
     * @return \StructType\Guest_1
     */
    public function setGST_OBJID($gST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gST_OBJID) && !is_string($gST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gST_OBJID, true), gettype($gST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gST_OBJID) && !preg_match('/([0-9])*/', $gST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gST_OBJID, true)), __LINE__);
        }
        $this->GST_OBJID = $this->{'GST-OBJID'} = $gST_OBJID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Guest_1
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Guest_1
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Guest_1
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\Guest_1
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Guest_1
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\Guest_1
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\Guest_1
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Guest_1
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get pobox value
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }
    /**
     * Set pobox value
     * @param string $pobox
     * @return \StructType\Guest_1
     */
    public function setPobox($pobox = null)
    {
        // validation for constraint: string
        if (!is_null($pobox) && !is_string($pobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pobox, true), gettype($pobox)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($pobox) && mb_strlen($pobox) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($pobox)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pobox) && mb_strlen($pobox) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pobox)), __LINE__);
        }
        $this->pobox = $pobox;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Guest_1
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Guest_1
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Guest_1
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email) && mb_strlen($email) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\Guest_1
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\Guest_1
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\Guest_1
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($identificationNo) && mb_strlen($identificationNo) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($identificationNo)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identificationNo) && mb_strlen($identificationNo) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\Guest_1
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\Guest_1
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\Guest_1
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get salutcorrespond value
     * @return string
     */
    public function getSalutcorrespond()
    {
        return $this->salutcorrespond;
    }
    /**
     * Set salutcorrespond value
     * @param string $salutcorrespond
     * @return \StructType\Guest_1
     */
    public function setSalutcorrespond($salutcorrespond = null)
    {
        // validation for constraint: string
        if (!is_null($salutcorrespond) && !is_string($salutcorrespond)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutcorrespond, true), gettype($salutcorrespond)), __LINE__);
        }
        $this->salutcorrespond = $salutcorrespond;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Guest_1
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \StructType\Guest_1
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone2) && mb_strlen($phone2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone2) && mb_strlen($phone2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\Guest_1
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get fax value
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Guest_1
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax) && mb_strlen($fax) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fax)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fax) && mb_strlen($fax) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get centralid value
     * @return string
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\Guest_1
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
    /**
     * Get vip value
     * @return string
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\Guest_1
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip) && mb_strlen($vip) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip) && mb_strlen($vip) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get vip2 value
     * @return string
     */
    public function getVip2()
    {
        return $this->vip2;
    }
    /**
     * Set vip2 value
     * @param string $vip2
     * @return \StructType\Guest_1
     */
    public function setVip2($vip2 = null)
    {
        // validation for constraint: string
        if (!is_null($vip2) && !is_string($vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip2, true), gettype($vip2)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip2) && mb_strlen($vip2) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip2) && mb_strlen($vip2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip2)), __LINE__);
        }
        $this->vip2 = $vip2;
        return $this;
    }
    /**
     * Get gsttype value
     * @return string
     */
    public function getGsttype()
    {
        return $this->gsttype;
    }
    /**
     * Set gsttype value
     * @param string $gsttype
     * @return \StructType\Guest_1
     */
    public function setGsttype($gsttype = null)
    {
        // validation for constraint: string
        if (!is_null($gsttype) && !is_string($gsttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsttype, true), gettype($gsttype)), __LINE__);
        }
        $this->gsttype = $gsttype;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\Guest_1
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\Guest_1
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get region value
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Guest_1
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\Guest_1
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get profession value
     * @return string
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\Guest_1
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($profession) && mb_strlen($profession) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($profession)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($profession) && mb_strlen($profession) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\Guest_1
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get placeofbirth value
     * @return string
     */
    public function getPlaceofbirth()
    {
        return $this->placeofbirth;
    }
    /**
     * Set placeofbirth value
     * @param string $placeofbirth
     * @return \StructType\Guest_1
     */
    public function setPlaceofbirth($placeofbirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeofbirth) && !is_string($placeofbirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeofbirth, true), gettype($placeofbirth)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($placeofbirth)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($placeofbirth)), __LINE__);
        }
        $this->placeofbirth = $placeofbirth;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\Guest_1
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get licenceplatenumber value
     * @return string
     */
    public function getLicenceplatenumber()
    {
        return $this->licenceplatenumber;
    }
    /**
     * Set licenceplatenumber value
     * @param string $licenceplatenumber
     * @return \StructType\Guest_1
     */
    public function setLicenceplatenumber($licenceplatenumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenceplatenumber) && !is_string($licenceplatenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenceplatenumber, true), gettype($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($licenceplatenumber)), __LINE__);
        }
        $this->licenceplatenumber = $licenceplatenumber;
        return $this;
    }
    /**
     * Get docissuedat value
     * @return string
     */
    public function getDocissuedat()
    {
        return $this->docissuedat;
    }
    /**
     * Set docissuedat value
     * @param string $docissuedat
     * @return \StructType\Guest_1
     */
    public function setDocissuedat($docissuedat = null)
    {
        // validation for constraint: string
        if (!is_null($docissuedat) && !is_string($docissuedat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuedat, true), gettype($docissuedat)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($docissuedat) && mb_strlen($docissuedat) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($docissuedat)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($docissuedat) && mb_strlen($docissuedat) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($docissuedat)), __LINE__);
        }
        $this->docissuedat = $docissuedat;
        return $this;
    }
    /**
     * Get docexpirydate value
     * @return string
     */
    public function getDocexpirydate()
    {
        return $this->docexpirydate;
    }
    /**
     * Set docexpirydate value
     * @param string $docexpirydate
     * @return \StructType\Guest_1
     */
    public function setDocexpirydate($docexpirydate = null)
    {
        // validation for constraint: string
        if (!is_null($docexpirydate) && !is_string($docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docexpirydate, true), gettype($docexpirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($docexpirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($docexpirydate, true)), __LINE__);
        }
        $this->docexpirydate = $docexpirydate;
        return $this;
    }
    /**
     * Get EXTERNALID value
     * @return \StructType\EXTERNALID[]|null
     */
    public function getEXTERNALID()
    {
        return $this->EXTERNALID;
    }
    /**
     * This method is responsible for validating the values passed to the setEXTERNALID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEXTERNALID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestEXTERNALIDItem) {
            // validation for constraint: itemType
            if (!$guestEXTERNALIDItem instanceof \StructType\EXTERNALID) {
                $invalidValues[] = is_object($guestEXTERNALIDItem) ? get_class($guestEXTERNALIDItem) : sprintf('%s(%s)', gettype($guestEXTERNALIDItem), var_export($guestEXTERNALIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID[] $eXTERNALID
     * @return \StructType\Guest_1
     */
    public function setEXTERNALID(array $eXTERNALID = array())
    {
        // validation for constraint: array
        if ('' !== ($eXTERNALIDArrayErrorMessage = self::validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID($eXTERNALID))) {
            throw new \InvalidArgumentException($eXTERNALIDArrayErrorMessage, __LINE__);
        }
        $this->EXTERNALID = $eXTERNALID;
        return $this;
    }
    /**
     * Add item to EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID $item
     * @return \StructType\Guest_1
     */
    public function addToEXTERNALID(\StructType\EXTERNALID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EXTERNALID) {
            throw new \InvalidArgumentException(sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EXTERNALID[] = $item;
        return $this;
    }
}
