<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestSearch StructType
 * @subpackage Structs
 */
class GuestSearch extends AbstractStructBase
{
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $guestType;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $matchcode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationNo;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * Constructor method for GuestSearch
     * @uses GuestSearch::setLastName()
     * @uses GuestSearch::setFirstName()
     * @uses GuestSearch::setGuestType()
     * @uses GuestSearch::setMatchcode()
     * @uses GuestSearch::setCountry()
     * @uses GuestSearch::setCity()
     * @uses GuestSearch::setPostcode()
     * @uses GuestSearch::setStreet()
     * @uses GuestSearch::setEmail()
     * @uses GuestSearch::setGuestNo()
     * @uses GuestSearch::setIdentificationNo()
     * @uses GuestSearch::setCentralid()
     * @param string $lastName
     * @param string $firstName
     * @param string $guestType
     * @param string $matchcode
     * @param string $country
     * @param string $city
     * @param string $postcode
     * @param string $street
     * @param string $email
     * @param string $guestNo
     * @param string $identificationNo
     * @param string $centralid
     */
    public function __construct($lastName = null, $firstName = null, $guestType = null, $matchcode = null, $country = null, $city = null, $postcode = null, $street = null, $email = null, $guestNo = null, $identificationNo = null, $centralid = null)
    {
        $this
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setGuestType($guestType)
            ->setMatchcode($matchcode)
            ->setCountry($country)
            ->setCity($city)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setEmail($email)
            ->setGuestNo($guestNo)
            ->setIdentificationNo($identificationNo)
            ->setCentralid($centralid);
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\GuestSearch
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\GuestSearch
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get guestType value
     * @return string|null
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\GuestSearch
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string|null
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\GuestSearch
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GuestSearch
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\GuestSearch
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GuestSearch
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\GuestSearch
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\GuestSearch
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string|null
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\GuestSearch
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string|null
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\GuestSearch
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get centralid value
     * @return string|null
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\GuestSearch
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
}
