<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestModifyData StructType
 * @subpackage Structs
 */
class GuestModifyData extends AbstractStructBase
{
    /**
     * The gsttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $gsttype;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $name2;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subsubcountry;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nationality;
    /**
     * The profession
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $profession;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $mobile1;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The placeofbirth
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $placeofbirth;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $birthcountry;
    /**
     * The licenceplatenumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $licenceplatenumber;
    /**
     * The documentnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 44
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $documentnumber;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $documenttype;
    /**
     * The documentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $documentdate;
    /**
     * The docissuingcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $docissuingcountry;
    /**
     * The docissuedat
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $docissuedat;
    /**
     * The docexpirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $docexpirydate;
    /**
     * Constructor method for GuestModifyData
     * @uses GuestModifyData::setGsttype()
     * @uses GuestModifyData::setName1()
     * @uses GuestModifyData::setAddress()
     * @uses GuestModifyData::setName2()
     * @uses GuestModifyData::setStreet()
     * @uses GuestModifyData::setPostcode()
     * @uses GuestModifyData::setCity()
     * @uses GuestModifyData::setCountry()
     * @uses GuestModifyData::setSubcountry()
     * @uses GuestModifyData::setSubsubcountry()
     * @uses GuestModifyData::setRegion()
     * @uses GuestModifyData::setNationality()
     * @uses GuestModifyData::setProfession()
     * @uses GuestModifyData::setEmail1()
     * @uses GuestModifyData::setMobile1()
     * @uses GuestModifyData::setBirthdate()
     * @uses GuestModifyData::setPlaceofbirth()
     * @uses GuestModifyData::setBirthcountry()
     * @uses GuestModifyData::setLicenceplatenumber()
     * @uses GuestModifyData::setDocumentnumber()
     * @uses GuestModifyData::setDocumenttype()
     * @uses GuestModifyData::setDocumentdate()
     * @uses GuestModifyData::setDocissuingcountry()
     * @uses GuestModifyData::setDocissuedat()
     * @uses GuestModifyData::setDocexpirydate()
     * @param string $gsttype
     * @param string $name1
     * @param string $address
     * @param string $name2
     * @param string $street
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $region
     * @param string $nationality
     * @param string $profession
     * @param string $email1
     * @param string $mobile1
     * @param string $birthdate
     * @param string $placeofbirth
     * @param string $birthcountry
     * @param string $licenceplatenumber
     * @param string $documentnumber
     * @param string $documenttype
     * @param string $documentdate
     * @param string $docissuingcountry
     * @param string $docissuedat
     * @param string $docexpirydate
     */
    public function __construct($gsttype = null, $name1 = null, $address = null, $name2 = null, $street = null, $postcode = null, $city = null, $country = null, $subcountry = null, $subsubcountry = null, $region = null, $nationality = null, $profession = null, $email1 = null, $mobile1 = null, $birthdate = null, $placeofbirth = null, $birthcountry = null, $licenceplatenumber = null, $documentnumber = null, $documenttype = null, $documentdate = null, $docissuingcountry = null, $docissuedat = null, $docexpirydate = null)
    {
        $this
            ->setGsttype($gsttype)
            ->setName1($name1)
            ->setAddress($address)
            ->setName2($name2)
            ->setStreet($street)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setProfession($profession)
            ->setEmail1($email1)
            ->setMobile1($mobile1)
            ->setBirthdate($birthdate)
            ->setPlaceofbirth($placeofbirth)
            ->setBirthcountry($birthcountry)
            ->setLicenceplatenumber($licenceplatenumber)
            ->setDocumentnumber($documentnumber)
            ->setDocumenttype($documenttype)
            ->setDocumentdate($documentdate)
            ->setDocissuingcountry($docissuingcountry)
            ->setDocissuedat($docissuedat)
            ->setDocexpirydate($docexpirydate);
    }
    /**
     * Get gsttype value
     * @return string
     */
    public function getGsttype()
    {
        return $this->gsttype;
    }
    /**
     * Set gsttype value
     * @param string $gsttype
     * @return \StructType\GuestModifyData
     */
    public function setGsttype($gsttype = null)
    {
        // validation for constraint: string
        if (!is_null($gsttype) && !is_string($gsttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsttype, true), gettype($gsttype)), __LINE__);
        }
        $this->gsttype = $gsttype;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\GuestModifyData
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\GuestModifyData
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\GuestModifyData
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\GuestModifyData
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GuestModifyData
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\GuestModifyData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GuestModifyData
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string|null
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\GuestModifyData
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string|null
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\GuestModifyData
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\GuestModifyData
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\GuestModifyData
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\GuestModifyData
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($profession) && mb_strlen($profession) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($profession)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($profession) && mb_strlen($profession) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get email1 value
     * @return string|null
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\GuestModifyData
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string|null
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\GuestModifyData
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\GuestModifyData
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get placeofbirth value
     * @return string|null
     */
    public function getPlaceofbirth()
    {
        return $this->placeofbirth;
    }
    /**
     * Set placeofbirth value
     * @param string $placeofbirth
     * @return \StructType\GuestModifyData
     */
    public function setPlaceofbirth($placeofbirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeofbirth) && !is_string($placeofbirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeofbirth, true), gettype($placeofbirth)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($placeofbirth)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($placeofbirth)), __LINE__);
        }
        $this->placeofbirth = $placeofbirth;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string|null
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\GuestModifyData
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get licenceplatenumber value
     * @return string|null
     */
    public function getLicenceplatenumber()
    {
        return $this->licenceplatenumber;
    }
    /**
     * Set licenceplatenumber value
     * @param string $licenceplatenumber
     * @return \StructType\GuestModifyData
     */
    public function setLicenceplatenumber($licenceplatenumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenceplatenumber) && !is_string($licenceplatenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenceplatenumber, true), gettype($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($licenceplatenumber)), __LINE__);
        }
        $this->licenceplatenumber = $licenceplatenumber;
        return $this;
    }
    /**
     * Get documentnumber value
     * @return string|null
     */
    public function getDocumentnumber()
    {
        return $this->documentnumber;
    }
    /**
     * Set documentnumber value
     * @param string $documentnumber
     * @return \StructType\GuestModifyData
     */
    public function setDocumentnumber($documentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentnumber) && !is_string($documentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnumber, true), gettype($documentnumber)), __LINE__);
        }
        // validation for constraint: maxLength(44)
        if (!is_null($documentnumber) && mb_strlen($documentnumber) > 44) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 44', mb_strlen($documentnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documentnumber) && mb_strlen($documentnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documentnumber)), __LINE__);
        }
        $this->documentnumber = $documentnumber;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \StructType\GuestModifyData
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($documenttype) && mb_strlen($documenttype) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($documenttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documenttype) && mb_strlen($documenttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentdate value
     * @return string|null
     */
    public function getDocumentdate()
    {
        return $this->documentdate;
    }
    /**
     * Set documentdate value
     * @param string $documentdate
     * @return \StructType\GuestModifyData
     */
    public function setDocumentdate($documentdate = null)
    {
        // validation for constraint: string
        if (!is_null($documentdate) && !is_string($documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentdate, true), gettype($documentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($documentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($documentdate, true)), __LINE__);
        }
        $this->documentdate = $documentdate;
        return $this;
    }
    /**
     * Get docissuingcountry value
     * @return string|null
     */
    public function getDocissuingcountry()
    {
        return $this->docissuingcountry;
    }
    /**
     * Set docissuingcountry value
     * @param string $docissuingcountry
     * @return \StructType\GuestModifyData
     */
    public function setDocissuingcountry($docissuingcountry = null)
    {
        // validation for constraint: string
        if (!is_null($docissuingcountry) && !is_string($docissuingcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuingcountry, true), gettype($docissuingcountry)), __LINE__);
        }
        $this->docissuingcountry = $docissuingcountry;
        return $this;
    }
    /**
     * Get docissuedat value
     * @return string|null
     */
    public function getDocissuedat()
    {
        return $this->docissuedat;
    }
    /**
     * Set docissuedat value
     * @param string $docissuedat
     * @return \StructType\GuestModifyData
     */
    public function setDocissuedat($docissuedat = null)
    {
        // validation for constraint: string
        if (!is_null($docissuedat) && !is_string($docissuedat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuedat, true), gettype($docissuedat)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($docissuedat) && mb_strlen($docissuedat) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($docissuedat)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($docissuedat) && mb_strlen($docissuedat) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($docissuedat)), __LINE__);
        }
        $this->docissuedat = $docissuedat;
        return $this;
    }
    /**
     * Get docexpirydate value
     * @return string|null
     */
    public function getDocexpirydate()
    {
        return $this->docexpirydate;
    }
    /**
     * Set docexpirydate value
     * @param string $docexpirydate
     * @return \StructType\GuestModifyData
     */
    public function setDocexpirydate($docexpirydate = null)
    {
        // validation for constraint: string
        if (!is_null($docexpirydate) && !is_string($docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docexpirydate, true), gettype($docexpirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($docexpirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($docexpirydate, true)), __LINE__);
        }
        $this->docexpirydate = $docexpirydate;
        return $this;
    }
}
