<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestIdentification StructType
 * @subpackage Structs
 */
class GuestIdentification extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The IDENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $IDENT_OBJID;
    /**
     * Constructor method for GuestIdentification
     * @uses GuestIdentification::setType()
     * @uses GuestIdentification::setNumber()
     * @uses GuestIdentification::setIDENT_OBJID()
     * @param string $type
     * @param string $number
     * @param string $iDENT_OBJID
     */
    public function __construct($type = null, $number = null, $iDENT_OBJID = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setIDENT_OBJID($iDENT_OBJID);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GuestIdentification
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type) && mb_strlen($type) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\GuestIdentification
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get IDENT_OBJID value
     * @return string|null
     */
    public function getIDENT_OBJID()
    {
        return $this->{'IDENT-OBJID'};
    }
    /**
     * Set IDENT_OBJID value
     * @param string $iDENT_OBJID
     * @return \StructType\GuestIdentification
     */
    public function setIDENT_OBJID($iDENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iDENT_OBJID) && !is_string($iDENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDENT_OBJID, true), gettype($iDENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iDENT_OBJID) && !preg_match('/([0-9])*/', $iDENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iDENT_OBJID, true)), __LINE__);
        }
        $this->IDENT_OBJID = $this->{'IDENT-OBJID'} = $iDENT_OBJID;
        return $this;
    }
}
