<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestHierarchyLevel6 StructType
 * @subpackage Structs
 */
class GuestHierarchyLevel6 extends AbstractStructBase
{
    /**
     * The objid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $objid;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $identificationNo;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * The GuestHierarchyLevel7
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestHierarchyLevel7[]
     */
    public $GuestHierarchyLevel7;
    /**
     * Constructor method for GuestHierarchyLevel6
     * @uses GuestHierarchyLevel6::setObjid()
     * @uses GuestHierarchyLevel6::setLastName()
     * @uses GuestHierarchyLevel6::setFirstName()
     * @uses GuestHierarchyLevel6::setGuestType()
     * @uses GuestHierarchyLevel6::setMatchcode()
     * @uses GuestHierarchyLevel6::setCountry()
     * @uses GuestHierarchyLevel6::setSubcountry()
     * @uses GuestHierarchyLevel6::setSubsubcountry()
     * @uses GuestHierarchyLevel6::setCity()
     * @uses GuestHierarchyLevel6::setPostcode()
     * @uses GuestHierarchyLevel6::setStreet()
     * @uses GuestHierarchyLevel6::setEmail()
     * @uses GuestHierarchyLevel6::setGuestHotel()
     * @uses GuestHierarchyLevel6::setGuestNo()
     * @uses GuestHierarchyLevel6::setIdentificationNo()
     * @uses GuestHierarchyLevel6::setCentralid()
     * @uses GuestHierarchyLevel6::setGuestHierarchyLevel7()
     * @param string $objid
     * @param string $lastName
     * @param string $firstName
     * @param string $guestType
     * @param string $matchcode
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $city
     * @param string $postcode
     * @param string $street
     * @param string $email
     * @param string $guestHotel
     * @param string $guestNo
     * @param string $identificationNo
     * @param string $centralid
     * @param \StructType\GuestHierarchyLevel7[] $guestHierarchyLevel7
     */
    public function __construct($objid = null, $lastName = null, $firstName = null, $guestType = null, $matchcode = null, $country = null, $subcountry = null, $subsubcountry = null, $city = null, $postcode = null, $street = null, $email = null, $guestHotel = null, $guestNo = null, $identificationNo = null, $centralid = null, array $guestHierarchyLevel7 = array())
    {
        $this
            ->setObjid($objid)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setGuestType($guestType)
            ->setMatchcode($matchcode)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setCity($city)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setEmail($email)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo)
            ->setIdentificationNo($identificationNo)
            ->setCentralid($centralid)
            ->setGuestHierarchyLevel7($guestHierarchyLevel7);
    }
    /**
     * Get objid value
     * @return string
     */
    public function getObjid()
    {
        return $this->objid;
    }
    /**
     * Set objid value
     * @param string $objid
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setObjid($objid = null)
    {
        // validation for constraint: string
        if (!is_null($objid) && !is_string($objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objid, true), gettype($objid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($objid) && !preg_match('/([0-9])*/', $objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($objid, true)), __LINE__);
        }
        $this->objid = $objid;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email) && mb_strlen($email) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($identificationNo) && mb_strlen($identificationNo) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($identificationNo)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identificationNo) && mb_strlen($identificationNo) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get centralid value
     * @return string
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
    /**
     * Get GuestHierarchyLevel7 value
     * @return \StructType\GuestHierarchyLevel7[]|null
     */
    public function getGuestHierarchyLevel7()
    {
        return $this->GuestHierarchyLevel7;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestHierarchyLevel7 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestHierarchyLevel7 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestHierarchyLevel7ForArrayConstraintsFromSetGuestHierarchyLevel7(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestHierarchyLevel6GuestHierarchyLevel7Item) {
            // validation for constraint: itemType
            if (!$guestHierarchyLevel6GuestHierarchyLevel7Item instanceof \StructType\GuestHierarchyLevel7) {
                $invalidValues[] = is_object($guestHierarchyLevel6GuestHierarchyLevel7Item) ? get_class($guestHierarchyLevel6GuestHierarchyLevel7Item) : sprintf('%s(%s)', gettype($guestHierarchyLevel6GuestHierarchyLevel7Item), var_export($guestHierarchyLevel6GuestHierarchyLevel7Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestHierarchyLevel7 property can only contain items of type \StructType\GuestHierarchyLevel7, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestHierarchyLevel7 value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestHierarchyLevel7[] $guestHierarchyLevel7
     * @return \StructType\GuestHierarchyLevel6
     */
    public function setGuestHierarchyLevel7(array $guestHierarchyLevel7 = array())
    {
        // validation for constraint: array
        if ('' !== ($guestHierarchyLevel7ArrayErrorMessage = self::validateGuestHierarchyLevel7ForArrayConstraintsFromSetGuestHierarchyLevel7($guestHierarchyLevel7))) {
            throw new \InvalidArgumentException($guestHierarchyLevel7ArrayErrorMessage, __LINE__);
        }
        $this->GuestHierarchyLevel7 = $guestHierarchyLevel7;
        return $this;
    }
    /**
     * Add item to GuestHierarchyLevel7 value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestHierarchyLevel7 $item
     * @return \StructType\GuestHierarchyLevel6
     */
    public function addToGuestHierarchyLevel7(\StructType\GuestHierarchyLevel7 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestHierarchyLevel7) {
            throw new \InvalidArgumentException(sprintf('The GuestHierarchyLevel7 property can only contain items of type \StructType\GuestHierarchyLevel7, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestHierarchyLevel7[] = $item;
        return $this;
    }
}
