<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUEST-MERGE StructType
 * @subpackage Structs
 */
class GUEST_MERGE extends AbstractStructBase
{
    /**
     * The TARGET_GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TARGET_GUEST
     */
    public $TARGET_GUEST;
    /**
     * The SOURCE_GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SOURCE_GUEST[]
     */
    public $SOURCE_GUEST;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $birthdate;
    /**
     * The citymerge
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $citymerge;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $country;
    /**
     * The street2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $street2;
    /**
     * The postcodemerge
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $postcodemerge;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $email1;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $fax;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $lastname;
    /**
     * The identnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $identnumber;
    /**
     * The internetpassword
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $internetpassword;
    /**
     * The historymerge
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $historymerge;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $marketsegment;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ratesegment;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $matchcode;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $note;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $phone;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $vip;
    /**
     * The vip2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $vip2;
    /**
     * Constructor method for GUEST-MERGE
     * @uses GUEST_MERGE::setTARGET_GUEST()
     * @uses GUEST_MERGE::setSOURCE_GUEST()
     * @uses GUEST_MERGE::setBirthdate()
     * @uses GUEST_MERGE::setCitymerge()
     * @uses GUEST_MERGE::setCountry()
     * @uses GUEST_MERGE::setStreet2()
     * @uses GUEST_MERGE::setPostcodemerge()
     * @uses GUEST_MERGE::setEmail1()
     * @uses GUEST_MERGE::setFax()
     * @uses GUEST_MERGE::setFirstname()
     * @uses GUEST_MERGE::setLastname()
     * @uses GUEST_MERGE::setIdentnumber()
     * @uses GUEST_MERGE::setInternetpassword()
     * @uses GUEST_MERGE::setHistorymerge()
     * @uses GUEST_MERGE::setMarketsegment()
     * @uses GUEST_MERGE::setRatesegment()
     * @uses GUEST_MERGE::setMatchcode()
     * @uses GUEST_MERGE::setNote()
     * @uses GUEST_MERGE::setPhone()
     * @uses GUEST_MERGE::setVip()
     * @uses GUEST_MERGE::setVip2()
     * @param \StructType\TARGET_GUEST $tARGET_GUEST
     * @param \StructType\SOURCE_GUEST[] $sOURCE_GUEST
     * @param string $birthdate
     * @param string $citymerge
     * @param string $country
     * @param string $street2
     * @param string $postcodemerge
     * @param string $email1
     * @param string $fax
     * @param string $firstname
     * @param string $lastname
     * @param string $identnumber
     * @param string $internetpassword
     * @param string $historymerge
     * @param string $marketsegment
     * @param string $ratesegment
     * @param string $matchcode
     * @param string $note
     * @param string $phone
     * @param string $vip
     * @param string $vip2
     */
    public function __construct(\StructType\TARGET_GUEST $tARGET_GUEST = null, array $sOURCE_GUEST = array(), $birthdate = null, $citymerge = null, $country = null, $street2 = null, $postcodemerge = null, $email1 = null, $fax = null, $firstname = null, $lastname = null, $identnumber = null, $internetpassword = null, $historymerge = null, $marketsegment = null, $ratesegment = null, $matchcode = null, $note = null, $phone = null, $vip = null, $vip2 = null)
    {
        $this
            ->setTARGET_GUEST($tARGET_GUEST)
            ->setSOURCE_GUEST($sOURCE_GUEST)
            ->setBirthdate($birthdate)
            ->setCitymerge($citymerge)
            ->setCountry($country)
            ->setStreet2($street2)
            ->setPostcodemerge($postcodemerge)
            ->setEmail1($email1)
            ->setFax($fax)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setIdentnumber($identnumber)
            ->setInternetpassword($internetpassword)
            ->setHistorymerge($historymerge)
            ->setMarketsegment($marketsegment)
            ->setRatesegment($ratesegment)
            ->setMatchcode($matchcode)
            ->setNote($note)
            ->setPhone($phone)
            ->setVip($vip)
            ->setVip2($vip2);
    }
    /**
     * Get TARGET_GUEST value
     * @return \StructType\TARGET_GUEST
     */
    public function getTARGET_GUEST()
    {
        return $this->{'TARGET-GUEST'};
    }
    /**
     * Set TARGET_GUEST value
     * @param \StructType\TARGET_GUEST $tARGET_GUEST
     * @return \StructType\GUEST_MERGE
     */
    public function setTARGET_GUEST(\StructType\TARGET_GUEST $tARGET_GUEST = null)
    {
        $this->TARGET_GUEST = $this->{'TARGET-GUEST'} = $tARGET_GUEST;
        return $this;
    }
    /**
     * Get SOURCE_GUEST value
     * @return \StructType\SOURCE_GUEST[]
     */
    public function getSOURCE_GUEST()
    {
        return $this->{'SOURCE-GUEST'};
    }
    /**
     * This method is responsible for validating the values passed to the setSOURCE_GUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSOURCE_GUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSOURCE_GUESTForArrayConstraintsFromSetSOURCE_GUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUEST_MERGESOURCE_GUESTItem) {
            // validation for constraint: itemType
            if (!$gUEST_MERGESOURCE_GUESTItem instanceof \StructType\SOURCE_GUEST) {
                $invalidValues[] = is_object($gUEST_MERGESOURCE_GUESTItem) ? get_class($gUEST_MERGESOURCE_GUESTItem) : sprintf('%s(%s)', gettype($gUEST_MERGESOURCE_GUESTItem), var_export($gUEST_MERGESOURCE_GUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SOURCE_GUEST property can only contain items of type \StructType\SOURCE_GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SOURCE_GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\SOURCE_GUEST[] $sOURCE_GUEST
     * @return \StructType\GUEST_MERGE
     */
    public function setSOURCE_GUEST(array $sOURCE_GUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($sOURCE_GUESTArrayErrorMessage = self::validateSOURCE_GUESTForArrayConstraintsFromSetSOURCE_GUEST($sOURCE_GUEST))) {
            throw new \InvalidArgumentException($sOURCE_GUESTArrayErrorMessage, __LINE__);
        }
        $this->SOURCE_GUEST = $this->{'SOURCE-GUEST'} = $sOURCE_GUEST;
        return $this;
    }
    /**
     * Add item to SOURCE_GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\SOURCE_GUEST $item
     * @return \StructType\GUEST_MERGE
     */
    public function addToSOURCE_GUEST(\StructType\SOURCE_GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SOURCE_GUEST) {
            throw new \InvalidArgumentException(sprintf('The SOURCE_GUEST property can only contain items of type \StructType\SOURCE_GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SOURCE_GUEST[] = $this->{'SOURCE-GUEST'}[] = $item;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\GUEST_MERGE
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($birthdate) && !preg_match('/([-+]){0,1}([0-9])*/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get citymerge value
     * @return string|null
     */
    public function getCitymerge()
    {
        return $this->citymerge;
    }
    /**
     * Set citymerge value
     * @param string $citymerge
     * @return \StructType\GUEST_MERGE
     */
    public function setCitymerge($citymerge = null)
    {
        // validation for constraint: string
        if (!is_null($citymerge) && !is_string($citymerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citymerge, true), gettype($citymerge)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($citymerge) && !preg_match('/([-+]){0,1}([0-9])*/', $citymerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($citymerge, true)), __LINE__);
        }
        $this->citymerge = $citymerge;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GUEST_MERGE
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($country) && !preg_match('/([-+]){0,1}([0-9])*/', $country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($country, true)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->street2;
    }
    /**
     * Set street2 value
     * @param string $street2
     * @return \StructType\GUEST_MERGE
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($street2) && !preg_match('/([-+]){0,1}([0-9])*/', $street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($street2, true)), __LINE__);
        }
        $this->street2 = $street2;
        return $this;
    }
    /**
     * Get postcodemerge value
     * @return string|null
     */
    public function getPostcodemerge()
    {
        return $this->postcodemerge;
    }
    /**
     * Set postcodemerge value
     * @param string $postcodemerge
     * @return \StructType\GUEST_MERGE
     */
    public function setPostcodemerge($postcodemerge = null)
    {
        // validation for constraint: string
        if (!is_null($postcodemerge) && !is_string($postcodemerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcodemerge, true), gettype($postcodemerge)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($postcodemerge) && !preg_match('/([-+]){0,1}([0-9])*/', $postcodemerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($postcodemerge, true)), __LINE__);
        }
        $this->postcodemerge = $postcodemerge;
        return $this;
    }
    /**
     * Get email1 value
     * @return string|null
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\GUEST_MERGE
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($email1) && !preg_match('/([-+]){0,1}([0-9])*/', $email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($email1, true)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\GUEST_MERGE
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($fax) && !preg_match('/([-+]){0,1}([0-9])*/', $fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($fax, true)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\GUEST_MERGE
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($firstname) && !preg_match('/([-+]){0,1}([0-9])*/', $firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($firstname, true)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\GUEST_MERGE
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($lastname) && !preg_match('/([-+]){0,1}([0-9])*/', $lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($lastname, true)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get identnumber value
     * @return string|null
     */
    public function getIdentnumber()
    {
        return $this->identnumber;
    }
    /**
     * Set identnumber value
     * @param string $identnumber
     * @return \StructType\GUEST_MERGE
     */
    public function setIdentnumber($identnumber = null)
    {
        // validation for constraint: string
        if (!is_null($identnumber) && !is_string($identnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identnumber, true), gettype($identnumber)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($identnumber) && !preg_match('/([-+]){0,1}([0-9])*/', $identnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($identnumber, true)), __LINE__);
        }
        $this->identnumber = $identnumber;
        return $this;
    }
    /**
     * Get internetpassword value
     * @return string|null
     */
    public function getInternetpassword()
    {
        return $this->internetpassword;
    }
    /**
     * Set internetpassword value
     * @param string $internetpassword
     * @return \StructType\GUEST_MERGE
     */
    public function setInternetpassword($internetpassword = null)
    {
        // validation for constraint: string
        if (!is_null($internetpassword) && !is_string($internetpassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internetpassword, true), gettype($internetpassword)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($internetpassword) && !preg_match('/([-+]){0,1}([0-9])*/', $internetpassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($internetpassword, true)), __LINE__);
        }
        $this->internetpassword = $internetpassword;
        return $this;
    }
    /**
     * Get historymerge value
     * @return string|null
     */
    public function getHistorymerge()
    {
        return $this->historymerge;
    }
    /**
     * Set historymerge value
     * @param string $historymerge
     * @return \StructType\GUEST_MERGE
     */
    public function setHistorymerge($historymerge = null)
    {
        // validation for constraint: string
        if (!is_null($historymerge) && !is_string($historymerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historymerge, true), gettype($historymerge)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($historymerge) && !preg_match('/([-+]){0,1}([0-9])*/', $historymerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($historymerge, true)), __LINE__);
        }
        $this->historymerge = $historymerge;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string|null
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\GUEST_MERGE
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($marketsegment) && !preg_match('/([-+]){0,1}([0-9])*/', $marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($marketsegment, true)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\GUEST_MERGE
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ratesegment) && !preg_match('/([-+]){0,1}([0-9])*/', $ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ratesegment, true)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string|null
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\GUEST_MERGE
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($matchcode) && !preg_match('/([-+]){0,1}([0-9])*/', $matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($matchcode, true)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\GUEST_MERGE
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($note) && !preg_match('/([-+]){0,1}([0-9])*/', $note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($note, true)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\GUEST_MERGE
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($phone) && !preg_match('/([-+]){0,1}([0-9])*/', $phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($phone, true)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get vip value
     * @return string|null
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\GUEST_MERGE
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($vip) && !preg_match('/([-+]){0,1}([0-9])*/', $vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($vip, true)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get vip2 value
     * @return string|null
     */
    public function getVip2()
    {
        return $this->vip2;
    }
    /**
     * Set vip2 value
     * @param string $vip2
     * @return \StructType\GUEST_MERGE
     */
    public function setVip2($vip2 = null)
    {
        // validation for constraint: string
        if (!is_null($vip2) && !is_string($vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip2, true), gettype($vip2)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($vip2) && !preg_match('/([-+]){0,1}([0-9])*/', $vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($vip2, true)), __LINE__);
        }
        $this->vip2 = $vip2;
        return $this;
    }
}
