<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUESTCRITERIA StructType
 * @subpackage Structs
 */
class GUESTCRITERIA extends AbstractStructBase
{
    /**
     * The DESCRIPTION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DESCRIPTION;
    /**
     * The TRAILTYPE
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $TRAILTYPE;
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TYPE;
    /**
     * The SUBTYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SUBTYPE;
    /**
     * The CRITERIA
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CRITERIA[]
     */
    public $CRITERIA;
    /**
     * The set
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $set;
    /**
     * Constructor method for GUESTCRITERIA
     * @uses GUESTCRITERIA::setDESCRIPTION()
     * @uses GUESTCRITERIA::setTRAILTYPE()
     * @uses GUESTCRITERIA::setTYPE()
     * @uses GUESTCRITERIA::setSUBTYPE()
     * @uses GUESTCRITERIA::setCRITERIA()
     * @uses GUESTCRITERIA::setSet()
     * @param string $dESCRIPTION
     * @param string $tRAILTYPE
     * @param string $tYPE
     * @param string $sUBTYPE
     * @param \StructType\CRITERIA[] $cRITERIA
     * @param string $set
     */
    public function __construct($dESCRIPTION = null, $tRAILTYPE = null, $tYPE = null, $sUBTYPE = null, array $cRITERIA = array(), $set = null)
    {
        $this
            ->setDESCRIPTION($dESCRIPTION)
            ->setTRAILTYPE($tRAILTYPE)
            ->setTYPE($tYPE)
            ->setSUBTYPE($sUBTYPE)
            ->setCRITERIA($cRITERIA)
            ->setSet($set);
    }
    /**
     * Get DESCRIPTION value
     * @return string
     */
    public function getDESCRIPTION()
    {
        return $this->DESCRIPTION;
    }
    /**
     * Set DESCRIPTION value
     * @param string $dESCRIPTION
     * @return \StructType\GUESTCRITERIA
     */
    public function setDESCRIPTION($dESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($dESCRIPTION) && !is_string($dESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dESCRIPTION, true), gettype($dESCRIPTION)), __LINE__);
        }
        $this->DESCRIPTION = $dESCRIPTION;
        return $this;
    }
    /**
     * Get TRAILTYPE value
     * @return string
     */
    public function getTRAILTYPE()
    {
        return $this->TRAILTYPE;
    }
    /**
     * Set TRAILTYPE value
     * @param string $tRAILTYPE
     * @return \StructType\GUESTCRITERIA
     */
    public function setTRAILTYPE($tRAILTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tRAILTYPE) && !is_string($tRAILTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAILTYPE, true), gettype($tRAILTYPE)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($tRAILTYPE) && !preg_match('/([-+]){0,1}([0-9])*/', $tRAILTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($tRAILTYPE, true)), __LINE__);
        }
        $this->TRAILTYPE = $tRAILTYPE;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\GUESTCRITERIA
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get SUBTYPE value
     * @return string
     */
    public function getSUBTYPE()
    {
        return $this->SUBTYPE;
    }
    /**
     * Set SUBTYPE value
     * @param string $sUBTYPE
     * @return \StructType\GUESTCRITERIA
     */
    public function setSUBTYPE($sUBTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($sUBTYPE) && !is_string($sUBTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBTYPE, true), gettype($sUBTYPE)), __LINE__);
        }
        $this->SUBTYPE = $sUBTYPE;
        return $this;
    }
    /**
     * Get CRITERIA value
     * @return \StructType\CRITERIA[]|null
     */
    public function getCRITERIA()
    {
        return $this->CRITERIA;
    }
    /**
     * This method is responsible for validating the values passed to the setCRITERIA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCRITERIA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCRITERIAForArrayConstraintsFromSetCRITERIA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTCRITERIACRITERIAItem) {
            // validation for constraint: itemType
            if (!$gUESTCRITERIACRITERIAItem instanceof \StructType\CRITERIA) {
                $invalidValues[] = is_object($gUESTCRITERIACRITERIAItem) ? get_class($gUESTCRITERIACRITERIAItem) : sprintf('%s(%s)', gettype($gUESTCRITERIACRITERIAItem), var_export($gUESTCRITERIACRITERIAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CRITERIA property can only contain items of type \StructType\CRITERIA, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\CRITERIA[] $cRITERIA
     * @return \StructType\GUESTCRITERIA
     */
    public function setCRITERIA(array $cRITERIA = array())
    {
        // validation for constraint: array
        if ('' !== ($cRITERIAArrayErrorMessage = self::validateCRITERIAForArrayConstraintsFromSetCRITERIA($cRITERIA))) {
            throw new \InvalidArgumentException($cRITERIAArrayErrorMessage, __LINE__);
        }
        $this->CRITERIA = $cRITERIA;
        return $this;
    }
    /**
     * Add item to CRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\CRITERIA $item
     * @return \StructType\GUESTCRITERIA
     */
    public function addToCRITERIA(\StructType\CRITERIA $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CRITERIA) {
            throw new \InvalidArgumentException(sprintf('The CRITERIA property can only contain items of type \StructType\CRITERIA, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CRITERIA[] = $item;
        return $this;
    }
    /**
     * Get set value
     * @return string|null
     */
    public function getSet()
    {
        return $this->set;
    }
    /**
     * Set set value
     * @param string $set
     * @return \StructType\GUESTCRITERIA
     */
    public function setSet($set = null)
    {
        // validation for constraint: string
        if (!is_null($set) && !is_string($set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($set, true), gettype($set)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($set) && !preg_match('/([-+]){0,1}([0-9])*/', $set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($set, true)), __LINE__);
        }
        $this->set = $set;
        return $this;
    }
}
