<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUESTACCOUNT StructType
 * @subpackage Structs
 */
class GUESTACCOUNT extends AbstractStructBase
{
    /**
     * The GUESTACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUESTACCOUNT_OBJID;
    /**
     * Constructor method for GUESTACCOUNT
     * @uses GUESTACCOUNT::setGUESTACCOUNT_OBJID()
     * @param string $gUESTACCOUNT_OBJID
     */
    public function __construct($gUESTACCOUNT_OBJID = null)
    {
        $this
            ->setGUESTACCOUNT_OBJID($gUESTACCOUNT_OBJID);
    }
    /**
     * Get GUESTACCOUNT_OBJID value
     * @return string
     */
    public function getGUESTACCOUNT_OBJID()
    {
        return $this->{'GUESTACCOUNT-OBJID'};
    }
    /**
     * Set GUESTACCOUNT_OBJID value
     * @param string $gUESTACCOUNT_OBJID
     * @return \StructType\GUESTACCOUNT
     */
    public function setGUESTACCOUNT_OBJID($gUESTACCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUESTACCOUNT_OBJID) && !is_string($gUESTACCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUESTACCOUNT_OBJID, true), gettype($gUESTACCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUESTACCOUNT_OBJID) && !preg_match('/([0-9])*/', $gUESTACCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUESTACCOUNT_OBJID, true)), __LINE__);
        }
        $this->GUESTACCOUNT_OBJID = $this->{'GUESTACCOUNT-OBJID'} = $gUESTACCOUNT_OBJID;
        return $this;
    }
}
