<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for followUp StructType
 * @subpackage Structs
 */
class FollowUp_1 extends AbstractStructBase
{
    /**
     * The TRAIL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TRAIL_OBJID;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The appointmentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $appointmentdate;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The enddate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $enddate;
    /**
     * The endtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $endtime;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $user;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The APPOINTMENT_FOLLOWUP_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $APPOINTMENT_FOLLOWUP_OBJID;
    /**
     * Constructor method for followUp
     * @uses FollowUp_1::setTRAIL_OBJID()
     * @uses FollowUp_1::setDescription()
     * @uses FollowUp_1::setStatus()
     * @uses FollowUp_1::setAppointmentdate()
     * @uses FollowUp_1::setTime()
     * @uses FollowUp_1::setEnddate()
     * @uses FollowUp_1::setEndtime()
     * @uses FollowUp_1::setUser()
     * @uses FollowUp_1::setComment()
     * @uses FollowUp_1::setAPPOINTMENT_FOLLOWUP_OBJID()
     * @param string $tRAIL_OBJID
     * @param string $description
     * @param string $status
     * @param string $appointmentdate
     * @param string $time
     * @param string $enddate
     * @param string $endtime
     * @param string $user
     * @param string $comment
     * @param string $aPPOINTMENT_FOLLOWUP_OBJID
     */
    public function __construct($tRAIL_OBJID = null, $description = null, $status = null, $appointmentdate = null, $time = null, $enddate = null, $endtime = null, $user = null, $comment = null, $aPPOINTMENT_FOLLOWUP_OBJID = null)
    {
        $this
            ->setTRAIL_OBJID($tRAIL_OBJID)
            ->setDescription($description)
            ->setStatus($status)
            ->setAppointmentdate($appointmentdate)
            ->setTime($time)
            ->setEnddate($enddate)
            ->setEndtime($endtime)
            ->setUser($user)
            ->setComment($comment)
            ->setAPPOINTMENT_FOLLOWUP_OBJID($aPPOINTMENT_FOLLOWUP_OBJID);
    }
    /**
     * Get TRAIL_OBJID value
     * @return string
     */
    public function getTRAIL_OBJID()
    {
        return $this->{'TRAIL-OBJID'};
    }
    /**
     * Set TRAIL_OBJID value
     * @param string $tRAIL_OBJID
     * @return \StructType\FollowUp_1
     */
    public function setTRAIL_OBJID($tRAIL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($tRAIL_OBJID) && !is_string($tRAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAIL_OBJID, true), gettype($tRAIL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tRAIL_OBJID) && !preg_match('/([0-9])*/', $tRAIL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tRAIL_OBJID, true)), __LINE__);
        }
        $this->TRAIL_OBJID = $this->{'TRAIL-OBJID'} = $tRAIL_OBJID;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FollowUp_1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($description) && mb_strlen($description) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\FollowUp_1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($status) && mb_strlen($status) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($status) && mb_strlen($status) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get appointmentdate value
     * @return string
     */
    public function getAppointmentdate()
    {
        return $this->appointmentdate;
    }
    /**
     * Set appointmentdate value
     * @param string $appointmentdate
     * @return \StructType\FollowUp_1
     */
    public function setAppointmentdate($appointmentdate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentdate) && !is_string($appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentdate, true), gettype($appointmentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($appointmentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $appointmentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($appointmentdate, true)), __LINE__);
        }
        $this->appointmentdate = $appointmentdate;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\FollowUp_1
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get enddate value
     * @return string
     */
    public function getEnddate()
    {
        return $this->enddate;
    }
    /**
     * Set enddate value
     * @param string $enddate
     * @return \StructType\FollowUp_1
     */
    public function setEnddate($enddate = null)
    {
        // validation for constraint: string
        if (!is_null($enddate) && !is_string($enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enddate, true), gettype($enddate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($enddate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $enddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($enddate, true)), __LINE__);
        }
        $this->enddate = $enddate;
        return $this;
    }
    /**
     * Get endtime value
     * @return string
     */
    public function getEndtime()
    {
        return $this->endtime;
    }
    /**
     * Set endtime value
     * @param string $endtime
     * @return \StructType\FollowUp_1
     */
    public function setEndtime($endtime = null)
    {
        // validation for constraint: string
        if (!is_null($endtime) && !is_string($endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endtime, true), gettype($endtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($endtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($endtime, true)), __LINE__);
        }
        $this->endtime = $endtime;
        return $this;
    }
    /**
     * Get user value
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\FollowUp_1
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($user) && mb_strlen($user) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($user)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($user) && mb_strlen($user) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\FollowUp_1
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get APPOINTMENT_FOLLOWUP_OBJID value
     * @return string
     */
    public function getAPPOINTMENT_FOLLOWUP_OBJID()
    {
        return $this->{'APPOINTMENT-FOLLOWUP-OBJID'};
    }
    /**
     * Set APPOINTMENT_FOLLOWUP_OBJID value
     * @param string $aPPOINTMENT_FOLLOWUP_OBJID
     * @return \StructType\FollowUp_1
     */
    public function setAPPOINTMENT_FOLLOWUP_OBJID($aPPOINTMENT_FOLLOWUP_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aPPOINTMENT_FOLLOWUP_OBJID) && !is_string($aPPOINTMENT_FOLLOWUP_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPOINTMENT_FOLLOWUP_OBJID, true), gettype($aPPOINTMENT_FOLLOWUP_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aPPOINTMENT_FOLLOWUP_OBJID) && !preg_match('/([0-9])*/', $aPPOINTMENT_FOLLOWUP_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aPPOINTMENT_FOLLOWUP_OBJID, true)), __LINE__);
        }
        $this->APPOINTMENT_FOLLOWUP_OBJID = $this->{'APPOINTMENT-FOLLOWUP-OBJID'} = $aPPOINTMENT_FOLLOWUP_OBJID;
        return $this;
    }
}
