<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalFileData StructType
 * @subpackage Structs
 */
class ExternalFileData extends AbstractStructBase
{
    /**
     * The base64String
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $base64String;
    /**
     * Constructor method for ExternalFileData
     * @uses ExternalFileData::setBase64String()
     * @param string $base64String
     */
    public function __construct($base64String = null)
    {
        $this
            ->setBase64String($base64String);
    }
    /**
     * Get base64String value
     * @return string
     */
    public function getBase64String()
    {
        return $this->base64String;
    }
    /**
     * Set base64String value
     * @param string $base64String
     * @return \StructType\ExternalFileData
     */
    public function setBase64String($base64String = null)
    {
        // validation for constraint: string
        if (!is_null($base64String) && !is_string($base64String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64String, true), gettype($base64String)), __LINE__);
        }
        $this->base64String = $base64String;
        return $this;
    }
}
