<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalAttachment StructType
 * @subpackage Structs
 */
class ExternalAttachment extends AbstractStructBase
{
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $filename;
    /**
     * The base64String
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $base64String;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for ExternalAttachment
     * @uses ExternalAttachment::setFilename()
     * @uses ExternalAttachment::setBase64String()
     * @uses ExternalAttachment::setComment()
     * @param string $filename
     * @param string $base64String
     * @param string $comment
     */
    public function __construct($filename = null, $base64String = null, $comment = null)
    {
        $this
            ->setFilename($filename)
            ->setBase64String($base64String)
            ->setComment($comment);
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\ExternalAttachment
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get base64String value
     * @return string|null
     */
    public function getBase64String()
    {
        return $this->base64String;
    }
    /**
     * Set base64String value
     * @param string $base64String
     * @return \StructType\ExternalAttachment
     */
    public function setBase64String($base64String = null)
    {
        // validation for constraint: string
        if (!is_null($base64String) && !is_string($base64String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64String, true), gettype($base64String)), __LINE__);
        }
        $this->base64String = $base64String;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\ExternalAttachment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
