<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVENT-ROOM StructType
 * @subpackage Structs
 */
class EVENT_ROOM extends AbstractStructBase
{
    /**
     * The EVENT_ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_ROOM_OBJID;
    /**
     * The eventroom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $eventroom;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The timefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The timeto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timeto;
    /**
     * The mainroom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mainroom;
    /**
     * The tablesetup
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $tablesetup;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The maxnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxnoofpax;
    /**
     * The roomrental
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $roomrental;
    /**
     * The charging
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $charging;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packages;
    /**
     * Constructor method for EVENT-ROOM
     * @uses EVENT_ROOM::setEVENT_ROOM_OBJID()
     * @uses EVENT_ROOM::setEventroom()
     * @uses EVENT_ROOM::setDescription()
     * @uses EVENT_ROOM::setDatefrom()
     * @uses EVENT_ROOM::setTimefrom()
     * @uses EVENT_ROOM::setDateto()
     * @uses EVENT_ROOM::setTimeto()
     * @uses EVENT_ROOM::setMainroom()
     * @uses EVENT_ROOM::setTablesetup()
     * @uses EVENT_ROOM::setNoofpax()
     * @uses EVENT_ROOM::setMaxnoofpax()
     * @uses EVENT_ROOM::setRoomrental()
     * @uses EVENT_ROOM::setCharging()
     * @uses EVENT_ROOM::setPackages()
     * @param string $eVENT_ROOM_OBJID
     * @param string $eventroom
     * @param string $description
     * @param string $datefrom
     * @param string $timefrom
     * @param string $dateto
     * @param string $timeto
     * @param string $mainroom
     * @param string $tablesetup
     * @param string $noofpax
     * @param string $maxnoofpax
     * @param string $roomrental
     * @param string $charging
     * @param string $packages
     */
    public function __construct($eVENT_ROOM_OBJID = null, $eventroom = null, $description = null, $datefrom = null, $timefrom = null, $dateto = null, $timeto = null, $mainroom = null, $tablesetup = null, $noofpax = null, $maxnoofpax = null, $roomrental = null, $charging = null, $packages = null)
    {
        $this
            ->setEVENT_ROOM_OBJID($eVENT_ROOM_OBJID)
            ->setEventroom($eventroom)
            ->setDescription($description)
            ->setDatefrom($datefrom)
            ->setTimefrom($timefrom)
            ->setDateto($dateto)
            ->setTimeto($timeto)
            ->setMainroom($mainroom)
            ->setTablesetup($tablesetup)
            ->setNoofpax($noofpax)
            ->setMaxnoofpax($maxnoofpax)
            ->setRoomrental($roomrental)
            ->setCharging($charging)
            ->setPackages($packages);
    }
    /**
     * Get EVENT_ROOM_OBJID value
     * @return string
     */
    public function getEVENT_ROOM_OBJID()
    {
        return $this->{'EVENT-ROOM-OBJID'};
    }
    /**
     * Set EVENT_ROOM_OBJID value
     * @param string $eVENT_ROOM_OBJID
     * @return \StructType\EVENT_ROOM
     */
    public function setEVENT_ROOM_OBJID($eVENT_ROOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_ROOM_OBJID) && !is_string($eVENT_ROOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_ROOM_OBJID, true), gettype($eVENT_ROOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_ROOM_OBJID) && !preg_match('/([0-9])*/', $eVENT_ROOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_ROOM_OBJID, true)), __LINE__);
        }
        $this->EVENT_ROOM_OBJID = $this->{'EVENT-ROOM-OBJID'} = $eVENT_ROOM_OBJID;
        return $this;
    }
    /**
     * Get eventroom value
     * @return string
     */
    public function getEventroom()
    {
        return $this->eventroom;
    }
    /**
     * Set eventroom value
     * @param string $eventroom
     * @return \StructType\EVENT_ROOM
     */
    public function setEventroom($eventroom = null)
    {
        // validation for constraint: string
        if (!is_null($eventroom) && !is_string($eventroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventroom, true), gettype($eventroom)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($eventroom) && mb_strlen($eventroom) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($eventroom)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eventroom) && mb_strlen($eventroom) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eventroom)), __LINE__);
        }
        $this->eventroom = $eventroom;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\EVENT_ROOM
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($description) && mb_strlen($description) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\EVENT_ROOM
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get timefrom value
     * @return string
     */
    public function getTimefrom()
    {
        return $this->timefrom;
    }
    /**
     * Set timefrom value
     * @param string $timefrom
     * @return \StructType\EVENT_ROOM
     */
    public function setTimefrom($timefrom = null)
    {
        // validation for constraint: string
        if (!is_null($timefrom) && !is_string($timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timefrom, true), gettype($timefrom)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timefrom) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timefrom, true)), __LINE__);
        }
        $this->timefrom = $timefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\EVENT_ROOM
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get timeto value
     * @return string
     */
    public function getTimeto()
    {
        return $this->timeto;
    }
    /**
     * Set timeto value
     * @param string $timeto
     * @return \StructType\EVENT_ROOM
     */
    public function setTimeto($timeto = null)
    {
        // validation for constraint: string
        if (!is_null($timeto) && !is_string($timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeto, true), gettype($timeto)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timeto) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timeto, true)), __LINE__);
        }
        $this->timeto = $timeto;
        return $this;
    }
    /**
     * Get mainroom value
     * @return string
     */
    public function getMainroom()
    {
        return $this->mainroom;
    }
    /**
     * Set mainroom value
     * @param string $mainroom
     * @return \StructType\EVENT_ROOM
     */
    public function setMainroom($mainroom = null)
    {
        // validation for constraint: string
        if (!is_null($mainroom) && !is_string($mainroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainroom, true), gettype($mainroom)), __LINE__);
        }
        $this->mainroom = $mainroom;
        return $this;
    }
    /**
     * Get tablesetup value
     * @return string
     */
    public function getTablesetup()
    {
        return $this->tablesetup;
    }
    /**
     * Set tablesetup value
     * @param string $tablesetup
     * @return \StructType\EVENT_ROOM
     */
    public function setTablesetup($tablesetup = null)
    {
        // validation for constraint: string
        if (!is_null($tablesetup) && !is_string($tablesetup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tablesetup, true), gettype($tablesetup)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($tablesetup) && mb_strlen($tablesetup) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($tablesetup)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tablesetup) && mb_strlen($tablesetup) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tablesetup)), __LINE__);
        }
        $this->tablesetup = $tablesetup;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\EVENT_ROOM
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get maxnoofpax value
     * @return string
     */
    public function getMaxnoofpax()
    {
        return $this->maxnoofpax;
    }
    /**
     * Set maxnoofpax value
     * @param string $maxnoofpax
     * @return \StructType\EVENT_ROOM
     */
    public function setMaxnoofpax($maxnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofpax) && !is_string($maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofpax, true), gettype($maxnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxnoofpax, true)), __LINE__);
        }
        $this->maxnoofpax = $maxnoofpax;
        return $this;
    }
    /**
     * Get roomrental value
     * @return string
     */
    public function getRoomrental()
    {
        return $this->roomrental;
    }
    /**
     * Set roomrental value
     * @param string $roomrental
     * @return \StructType\EVENT_ROOM
     */
    public function setRoomrental($roomrental = null)
    {
        // validation for constraint: string
        if (!is_null($roomrental) && !is_string($roomrental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomrental, true), gettype($roomrental)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($roomrental) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $roomrental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($roomrental, true)), __LINE__);
        }
        $this->roomrental = $roomrental;
        return $this;
    }
    /**
     * Get charging value
     * @return string
     */
    public function getCharging()
    {
        return $this->charging;
    }
    /**
     * Set charging value
     * @param string $charging
     * @return \StructType\EVENT_ROOM
     */
    public function setCharging($charging = null)
    {
        // validation for constraint: string
        if (!is_null($charging) && !is_string($charging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charging, true), gettype($charging)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($charging) && !preg_match('/([-+]){0,1}([0-9])*/', $charging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($charging, true)), __LINE__);
        }
        $this->charging = $charging;
        return $this;
    }
    /**
     * Get packages value
     * @return string
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param string $packages
     * @return \StructType\EVENT_ROOM
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: string
        if (!is_null($packages) && !is_string($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packages, true), gettype($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
}
