<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVENT-RESERVATION StructType
 * @subpackage Structs
 */
class EVENT_RESERVATION extends AbstractStructBase
{
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The restype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $restype;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The timefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The timeto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timeto;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The eventtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $eventtype;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $channel;
    /**
     * The nn1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nn1;
    /**
     * The nn3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nn3;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 201
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $note;
    /**
     * The EVENT_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_RESERVATION_OBJID;
    /**
     * The eventno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $eventno;
    /**
     * The reasonforcancellation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $reasonforcancellation;
    /**
     * The optiontodate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $optiontodate;
    /**
     * The createdon
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $createdon;
    /**
     * The createdat
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $createdat;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The functionboard
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $functionboard;
    /**
     * The processingstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $processingstatus;
    /**
     * The eventclassification
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $eventclassification;
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $deposit;
    /**
     * The operatorresponsible1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $operatorresponsible1;
    /**
     * The operatorresponsible2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $operatorresponsible2;
    /**
     * The operatorresponsible3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $operatorresponsible3;
    /**
     * The operatorresponsible4
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $operatorresponsible4;
    /**
     * The EXTERNALIDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EXTERNALIDS
     */
    public $EXTERNALIDS;
    /**
     * The RESERVATIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RESERVATIONS
     */
    public $RESERVATIONS;
    /**
     * The EVENT_ROOMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EVENT_ROOMS
     */
    public $EVENT_ROOMS;
    /**
     * The ressource
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ressource;
    /**
     * The resmedium
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $resmedium;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $gdsresnumber;
    /**
     * The CARD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CARD
     */
    public $CARD;
    /**
     * The ORDERER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORDERER
     */
    public $ORDERER;
    /**
     * The ORDERER_CONTACT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORDERER_CONTACT
     */
    public $ORDERER_CONTACT;
    /**
     * The EXTERNALID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EXTERNALID
     */
    public $EXTERNALID;
    /**
     * The INVOICE_HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE_HOLDER[]
     */
    public $INVOICE_HOLDER;
    /**
     * The mainroom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mainroom;
    /**
     * Constructor method for EVENT-RESERVATION
     * @uses EVENT_RESERVATION::setHotel()
     * @uses EVENT_RESERVATION::setRestype()
     * @uses EVENT_RESERVATION::setDatefrom()
     * @uses EVENT_RESERVATION::setTimefrom()
     * @uses EVENT_RESERVATION::setDateto()
     * @uses EVENT_RESERVATION::setTimeto()
     * @uses EVENT_RESERVATION::setMarketsegment()
     * @uses EVENT_RESERVATION::setRatesegment()
     * @uses EVENT_RESERVATION::setEventtype()
     * @uses EVENT_RESERVATION::setNoofpax()
     * @uses EVENT_RESERVATION::setChannel()
     * @uses EVENT_RESERVATION::setNn1()
     * @uses EVENT_RESERVATION::setNn3()
     * @uses EVENT_RESERVATION::setExternalreference()
     * @uses EVENT_RESERVATION::setNote()
     * @uses EVENT_RESERVATION::setEVENT_RESERVATION_OBJID()
     * @uses EVENT_RESERVATION::setEventno()
     * @uses EVENT_RESERVATION::setReasonforcancellation()
     * @uses EVENT_RESERVATION::setOptiontodate()
     * @uses EVENT_RESERVATION::setCreatedon()
     * @uses EVENT_RESERVATION::setCreatedat()
     * @uses EVENT_RESERVATION::setCurrency()
     * @uses EVENT_RESERVATION::setFunctionboard()
     * @uses EVENT_RESERVATION::setProcessingstatus()
     * @uses EVENT_RESERVATION::setEventclassification()
     * @uses EVENT_RESERVATION::setDeposit()
     * @uses EVENT_RESERVATION::setOperatorresponsible1()
     * @uses EVENT_RESERVATION::setOperatorresponsible2()
     * @uses EVENT_RESERVATION::setOperatorresponsible3()
     * @uses EVENT_RESERVATION::setOperatorresponsible4()
     * @uses EVENT_RESERVATION::setEXTERNALIDS()
     * @uses EVENT_RESERVATION::setRESERVATIONS()
     * @uses EVENT_RESERVATION::setEVENT_ROOMS()
     * @uses EVENT_RESERVATION::setRessource()
     * @uses EVENT_RESERVATION::setResmedium()
     * @uses EVENT_RESERVATION::setGdsresnumber()
     * @uses EVENT_RESERVATION::setCARD()
     * @uses EVENT_RESERVATION::setORDERER()
     * @uses EVENT_RESERVATION::setORDERER_CONTACT()
     * @uses EVENT_RESERVATION::setEXTERNALID()
     * @uses EVENT_RESERVATION::setINVOICE_HOLDER()
     * @uses EVENT_RESERVATION::setMainroom()
     * @param string $hotel
     * @param string $restype
     * @param string $datefrom
     * @param string $timefrom
     * @param string $dateto
     * @param string $timeto
     * @param string $marketsegment
     * @param string $ratesegment
     * @param string $eventtype
     * @param string $noofpax
     * @param string $channel
     * @param string $nn1
     * @param string $nn3
     * @param string $externalreference
     * @param string $note
     * @param string $eVENT_RESERVATION_OBJID
     * @param string $eventno
     * @param string $reasonforcancellation
     * @param string $optiontodate
     * @param string $createdon
     * @param string $createdat
     * @param string $currency
     * @param string $functionboard
     * @param string $processingstatus
     * @param string $eventclassification
     * @param string $deposit
     * @param string $operatorresponsible1
     * @param string $operatorresponsible2
     * @param string $operatorresponsible3
     * @param string $operatorresponsible4
     * @param \StructType\EXTERNALIDS $eXTERNALIDS
     * @param \StructType\RESERVATIONS $rESERVATIONS
     * @param \StructType\EVENT_ROOMS $eVENT_ROOMS
     * @param string $ressource
     * @param string $resmedium
     * @param string $gdsresnumber
     * @param \StructType\CARD $cARD
     * @param \StructType\ORDERER $oRDERER
     * @param \StructType\ORDERER_CONTACT $oRDERER_CONTACT
     * @param \StructType\EXTERNALID $eXTERNALID
     * @param \StructType\INVOICE_HOLDER[] $iNVOICE_HOLDER
     * @param string $mainroom
     */
    public function __construct($hotel = null, $restype = null, $datefrom = null, $timefrom = null, $dateto = null, $timeto = null, $marketsegment = null, $ratesegment = null, $eventtype = null, $noofpax = null, $channel = null, $nn1 = null, $nn3 = null, $externalreference = null, $note = null, $eVENT_RESERVATION_OBJID = null, $eventno = null, $reasonforcancellation = null, $optiontodate = null, $createdon = null, $createdat = null, $currency = null, $functionboard = null, $processingstatus = null, $eventclassification = null, $deposit = null, $operatorresponsible1 = null, $operatorresponsible2 = null, $operatorresponsible3 = null, $operatorresponsible4 = null, \StructType\EXTERNALIDS $eXTERNALIDS = null, \StructType\RESERVATIONS $rESERVATIONS = null, \StructType\EVENT_ROOMS $eVENT_ROOMS = null, $ressource = null, $resmedium = null, $gdsresnumber = null, \StructType\CARD $cARD = null, \StructType\ORDERER $oRDERER = null, \StructType\ORDERER_CONTACT $oRDERER_CONTACT = null, \StructType\EXTERNALID $eXTERNALID = null, array $iNVOICE_HOLDER = array(), $mainroom = null)
    {
        $this
            ->setHotel($hotel)
            ->setRestype($restype)
            ->setDatefrom($datefrom)
            ->setTimefrom($timefrom)
            ->setDateto($dateto)
            ->setTimeto($timeto)
            ->setMarketsegment($marketsegment)
            ->setRatesegment($ratesegment)
            ->setEventtype($eventtype)
            ->setNoofpax($noofpax)
            ->setChannel($channel)
            ->setNn1($nn1)
            ->setNn3($nn3)
            ->setExternalreference($externalreference)
            ->setNote($note)
            ->setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID)
            ->setEventno($eventno)
            ->setReasonforcancellation($reasonforcancellation)
            ->setOptiontodate($optiontodate)
            ->setCreatedon($createdon)
            ->setCreatedat($createdat)
            ->setCurrency($currency)
            ->setFunctionboard($functionboard)
            ->setProcessingstatus($processingstatus)
            ->setEventclassification($eventclassification)
            ->setDeposit($deposit)
            ->setOperatorresponsible1($operatorresponsible1)
            ->setOperatorresponsible2($operatorresponsible2)
            ->setOperatorresponsible3($operatorresponsible3)
            ->setOperatorresponsible4($operatorresponsible4)
            ->setEXTERNALIDS($eXTERNALIDS)
            ->setRESERVATIONS($rESERVATIONS)
            ->setEVENT_ROOMS($eVENT_ROOMS)
            ->setRessource($ressource)
            ->setResmedium($resmedium)
            ->setGdsresnumber($gdsresnumber)
            ->setCARD($cARD)
            ->setORDERER($oRDERER)
            ->setORDERER_CONTACT($oRDERER_CONTACT)
            ->setEXTERNALID($eXTERNALID)
            ->setINVOICE_HOLDER($iNVOICE_HOLDER)
            ->setMainroom($mainroom);
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\EVENT_RESERVATION
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get restype value
     * @return string
     */
    public function getRestype()
    {
        return $this->restype;
    }
    /**
     * Set restype value
     * @param string $restype
     * @return \StructType\EVENT_RESERVATION
     */
    public function setRestype($restype = null)
    {
        // validation for constraint: string
        if (!is_null($restype) && !is_string($restype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restype, true), gettype($restype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($restype) && mb_strlen($restype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($restype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($restype) && mb_strlen($restype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($restype)), __LINE__);
        }
        $this->restype = $restype;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\EVENT_RESERVATION
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get timefrom value
     * @return string
     */
    public function getTimefrom()
    {
        return $this->timefrom;
    }
    /**
     * Set timefrom value
     * @param string $timefrom
     * @return \StructType\EVENT_RESERVATION
     */
    public function setTimefrom($timefrom = null)
    {
        // validation for constraint: string
        if (!is_null($timefrom) && !is_string($timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timefrom, true), gettype($timefrom)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timefrom) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timefrom, true)), __LINE__);
        }
        $this->timefrom = $timefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\EVENT_RESERVATION
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get timeto value
     * @return string
     */
    public function getTimeto()
    {
        return $this->timeto;
    }
    /**
     * Set timeto value
     * @param string $timeto
     * @return \StructType\EVENT_RESERVATION
     */
    public function setTimeto($timeto = null)
    {
        // validation for constraint: string
        if (!is_null($timeto) && !is_string($timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeto, true), gettype($timeto)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timeto) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timeto, true)), __LINE__);
        }
        $this->timeto = $timeto;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\EVENT_RESERVATION
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\EVENT_RESERVATION
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get eventtype value
     * @return string
     */
    public function getEventtype()
    {
        return $this->eventtype;
    }
    /**
     * Set eventtype value
     * @param string $eventtype
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEventtype($eventtype = null)
    {
        // validation for constraint: string
        if (!is_null($eventtype) && !is_string($eventtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventtype, true), gettype($eventtype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($eventtype) && mb_strlen($eventtype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($eventtype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eventtype) && mb_strlen($eventtype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eventtype)), __LINE__);
        }
        $this->eventtype = $eventtype;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\EVENT_RESERVATION
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get channel value
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \StructType\EVENT_RESERVATION
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($channel) && mb_strlen($channel) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($channel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($channel) && mb_strlen($channel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get nn1 value
     * @return string
     */
    public function getNn1()
    {
        return $this->nn1;
    }
    /**
     * Set nn1 value
     * @param string $nn1
     * @return \StructType\EVENT_RESERVATION
     */
    public function setNn1($nn1 = null)
    {
        // validation for constraint: string
        if (!is_null($nn1) && !is_string($nn1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nn1, true), gettype($nn1)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($nn1) && mb_strlen($nn1) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($nn1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nn1) && mb_strlen($nn1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nn1)), __LINE__);
        }
        $this->nn1 = $nn1;
        return $this;
    }
    /**
     * Get nn3 value
     * @return string
     */
    public function getNn3()
    {
        return $this->nn3;
    }
    /**
     * Set nn3 value
     * @param string $nn3
     * @return \StructType\EVENT_RESERVATION
     */
    public function setNn3($nn3 = null)
    {
        // validation for constraint: string
        if (!is_null($nn3) && !is_string($nn3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nn3, true), gettype($nn3)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($nn3) && mb_strlen($nn3) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($nn3)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nn3) && mb_strlen($nn3) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nn3)), __LINE__);
        }
        $this->nn3 = $nn3;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\EVENT_RESERVATION
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get note value
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\EVENT_RESERVATION
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: maxLength(201)
        if (!is_null($note) && mb_strlen($note) > 201) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 201', mb_strlen($note)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($note) && mb_strlen($note) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get EVENT_RESERVATION_OBJID value
     * @return string
     */
    public function getEVENT_RESERVATION_OBJID()
    {
        return $this->{'EVENT-RESERVATION-OBJID'};
    }
    /**
     * Set EVENT_RESERVATION_OBJID value
     * @param string $eVENT_RESERVATION_OBJID
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_RESERVATION_OBJID) && !is_string($eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_RESERVATION_OBJID, true), gettype($eVENT_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->EVENT_RESERVATION_OBJID = $this->{'EVENT-RESERVATION-OBJID'} = $eVENT_RESERVATION_OBJID;
        return $this;
    }
    /**
     * Get eventno value
     * @return string
     */
    public function getEventno()
    {
        return $this->eventno;
    }
    /**
     * Set eventno value
     * @param string $eventno
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEventno($eventno = null)
    {
        // validation for constraint: string
        if (!is_null($eventno) && !is_string($eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventno, true), gettype($eventno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($eventno) && !preg_match('/([-+]){0,1}([0-9])*/', $eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($eventno, true)), __LINE__);
        }
        $this->eventno = $eventno;
        return $this;
    }
    /**
     * Get reasonforcancellation value
     * @return string
     */
    public function getReasonforcancellation()
    {
        return $this->reasonforcancellation;
    }
    /**
     * Set reasonforcancellation value
     * @param string $reasonforcancellation
     * @return \StructType\EVENT_RESERVATION
     */
    public function setReasonforcancellation($reasonforcancellation = null)
    {
        // validation for constraint: string
        if (!is_null($reasonforcancellation) && !is_string($reasonforcancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonforcancellation, true), gettype($reasonforcancellation)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($reasonforcancellation) && mb_strlen($reasonforcancellation) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($reasonforcancellation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($reasonforcancellation) && mb_strlen($reasonforcancellation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($reasonforcancellation)), __LINE__);
        }
        $this->reasonforcancellation = $reasonforcancellation;
        return $this;
    }
    /**
     * Get optiontodate value
     * @return string
     */
    public function getOptiontodate()
    {
        return $this->optiontodate;
    }
    /**
     * Set optiontodate value
     * @param string $optiontodate
     * @return \StructType\EVENT_RESERVATION
     */
    public function setOptiontodate($optiontodate = null)
    {
        // validation for constraint: string
        if (!is_null($optiontodate) && !is_string($optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optiontodate, true), gettype($optiontodate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($optiontodate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($optiontodate, true)), __LINE__);
        }
        $this->optiontodate = $optiontodate;
        return $this;
    }
    /**
     * Get createdon value
     * @return string
     */
    public function getCreatedon()
    {
        return $this->createdon;
    }
    /**
     * Set createdon value
     * @param string $createdon
     * @return \StructType\EVENT_RESERVATION
     */
    public function setCreatedon($createdon = null)
    {
        // validation for constraint: string
        if (!is_null($createdon) && !is_string($createdon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdon, true), gettype($createdon)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($createdon) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $createdon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($createdon, true)), __LINE__);
        }
        $this->createdon = $createdon;
        return $this;
    }
    /**
     * Get createdat value
     * @return string
     */
    public function getCreatedat()
    {
        return $this->createdat;
    }
    /**
     * Set createdat value
     * @param string $createdat
     * @return \StructType\EVENT_RESERVATION
     */
    public function setCreatedat($createdat = null)
    {
        // validation for constraint: string
        if (!is_null($createdat) && !is_string($createdat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdat, true), gettype($createdat)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($createdat) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $createdat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($createdat, true)), __LINE__);
        }
        $this->createdat = $createdat;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\EVENT_RESERVATION
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get functionboard value
     * @return string
     */
    public function getFunctionboard()
    {
        return $this->functionboard;
    }
    /**
     * Set functionboard value
     * @param string $functionboard
     * @return \StructType\EVENT_RESERVATION
     */
    public function setFunctionboard($functionboard = null)
    {
        // validation for constraint: string
        if (!is_null($functionboard) && !is_string($functionboard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functionboard, true), gettype($functionboard)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($functionboard) && mb_strlen($functionboard) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($functionboard)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($functionboard) && mb_strlen($functionboard) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($functionboard)), __LINE__);
        }
        $this->functionboard = $functionboard;
        return $this;
    }
    /**
     * Get processingstatus value
     * @return string
     */
    public function getProcessingstatus()
    {
        return $this->processingstatus;
    }
    /**
     * Set processingstatus value
     * @param string $processingstatus
     * @return \StructType\EVENT_RESERVATION
     */
    public function setProcessingstatus($processingstatus = null)
    {
        // validation for constraint: string
        if (!is_null($processingstatus) && !is_string($processingstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingstatus, true), gettype($processingstatus)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($processingstatus) && mb_strlen($processingstatus) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($processingstatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($processingstatus) && mb_strlen($processingstatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($processingstatus)), __LINE__);
        }
        $this->processingstatus = $processingstatus;
        return $this;
    }
    /**
     * Get eventclassification value
     * @return string
     */
    public function getEventclassification()
    {
        return $this->eventclassification;
    }
    /**
     * Set eventclassification value
     * @param string $eventclassification
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEventclassification($eventclassification = null)
    {
        // validation for constraint: string
        if (!is_null($eventclassification) && !is_string($eventclassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventclassification, true), gettype($eventclassification)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($eventclassification) && mb_strlen($eventclassification) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($eventclassification)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eventclassification) && mb_strlen($eventclassification) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eventclassification)), __LINE__);
        }
        $this->eventclassification = $eventclassification;
        return $this;
    }
    /**
     * Get deposit value
     * @return string
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param string $deposit
     * @return \StructType\EVENT_RESERVATION
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: string
        if (!is_null($deposit) && !is_string($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deposit, true), gettype($deposit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($deposit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($deposit, true)), __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get operatorresponsible1 value
     * @return string
     */
    public function getOperatorresponsible1()
    {
        return $this->operatorresponsible1;
    }
    /**
     * Set operatorresponsible1 value
     * @param string $operatorresponsible1
     * @return \StructType\EVENT_RESERVATION
     */
    public function setOperatorresponsible1($operatorresponsible1 = null)
    {
        // validation for constraint: string
        if (!is_null($operatorresponsible1) && !is_string($operatorresponsible1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatorresponsible1, true), gettype($operatorresponsible1)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operatorresponsible1) && mb_strlen($operatorresponsible1) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operatorresponsible1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operatorresponsible1) && mb_strlen($operatorresponsible1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operatorresponsible1)), __LINE__);
        }
        $this->operatorresponsible1 = $operatorresponsible1;
        return $this;
    }
    /**
     * Get operatorresponsible2 value
     * @return string
     */
    public function getOperatorresponsible2()
    {
        return $this->operatorresponsible2;
    }
    /**
     * Set operatorresponsible2 value
     * @param string $operatorresponsible2
     * @return \StructType\EVENT_RESERVATION
     */
    public function setOperatorresponsible2($operatorresponsible2 = null)
    {
        // validation for constraint: string
        if (!is_null($operatorresponsible2) && !is_string($operatorresponsible2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatorresponsible2, true), gettype($operatorresponsible2)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operatorresponsible2) && mb_strlen($operatorresponsible2) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operatorresponsible2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operatorresponsible2) && mb_strlen($operatorresponsible2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operatorresponsible2)), __LINE__);
        }
        $this->operatorresponsible2 = $operatorresponsible2;
        return $this;
    }
    /**
     * Get operatorresponsible3 value
     * @return string
     */
    public function getOperatorresponsible3()
    {
        return $this->operatorresponsible3;
    }
    /**
     * Set operatorresponsible3 value
     * @param string $operatorresponsible3
     * @return \StructType\EVENT_RESERVATION
     */
    public function setOperatorresponsible3($operatorresponsible3 = null)
    {
        // validation for constraint: string
        if (!is_null($operatorresponsible3) && !is_string($operatorresponsible3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatorresponsible3, true), gettype($operatorresponsible3)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operatorresponsible3) && mb_strlen($operatorresponsible3) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operatorresponsible3)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operatorresponsible3) && mb_strlen($operatorresponsible3) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operatorresponsible3)), __LINE__);
        }
        $this->operatorresponsible3 = $operatorresponsible3;
        return $this;
    }
    /**
     * Get operatorresponsible4 value
     * @return string
     */
    public function getOperatorresponsible4()
    {
        return $this->operatorresponsible4;
    }
    /**
     * Set operatorresponsible4 value
     * @param string $operatorresponsible4
     * @return \StructType\EVENT_RESERVATION
     */
    public function setOperatorresponsible4($operatorresponsible4 = null)
    {
        // validation for constraint: string
        if (!is_null($operatorresponsible4) && !is_string($operatorresponsible4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatorresponsible4, true), gettype($operatorresponsible4)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operatorresponsible4) && mb_strlen($operatorresponsible4) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operatorresponsible4)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operatorresponsible4) && mb_strlen($operatorresponsible4) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operatorresponsible4)), __LINE__);
        }
        $this->operatorresponsible4 = $operatorresponsible4;
        return $this;
    }
    /**
     * Get EXTERNALIDS value
     * @return \StructType\EXTERNALIDS
     */
    public function getEXTERNALIDS()
    {
        return $this->EXTERNALIDS;
    }
    /**
     * Set EXTERNALIDS value
     * @param \StructType\EXTERNALIDS $eXTERNALIDS
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEXTERNALIDS(\StructType\EXTERNALIDS $eXTERNALIDS = null)
    {
        $this->EXTERNALIDS = $eXTERNALIDS;
        return $this;
    }
    /**
     * Get RESERVATIONS value
     * @return \StructType\RESERVATIONS
     */
    public function getRESERVATIONS()
    {
        return $this->RESERVATIONS;
    }
    /**
     * Set RESERVATIONS value
     * @param \StructType\RESERVATIONS $rESERVATIONS
     * @return \StructType\EVENT_RESERVATION
     */
    public function setRESERVATIONS(\StructType\RESERVATIONS $rESERVATIONS = null)
    {
        $this->RESERVATIONS = $rESERVATIONS;
        return $this;
    }
    /**
     * Get EVENT_ROOMS value
     * @return \StructType\EVENT_ROOMS
     */
    public function getEVENT_ROOMS()
    {
        return $this->{'EVENT-ROOMS'};
    }
    /**
     * Set EVENT_ROOMS value
     * @param \StructType\EVENT_ROOMS $eVENT_ROOMS
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEVENT_ROOMS(\StructType\EVENT_ROOMS $eVENT_ROOMS = null)
    {
        $this->EVENT_ROOMS = $this->{'EVENT-ROOMS'} = $eVENT_ROOMS;
        return $this;
    }
    /**
     * Get ressource value
     * @return string
     */
    public function getRessource()
    {
        return $this->ressource;
    }
    /**
     * Set ressource value
     * @param string $ressource
     * @return \StructType\EVENT_RESERVATION
     */
    public function setRessource($ressource = null)
    {
        // validation for constraint: string
        if (!is_null($ressource) && !is_string($ressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ressource, true), gettype($ressource)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ressource) && mb_strlen($ressource) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ressource)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ressource) && mb_strlen($ressource) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ressource)), __LINE__);
        }
        $this->ressource = $ressource;
        return $this;
    }
    /**
     * Get resmedium value
     * @return string
     */
    public function getResmedium()
    {
        return $this->resmedium;
    }
    /**
     * Set resmedium value
     * @param string $resmedium
     * @return \StructType\EVENT_RESERVATION
     */
    public function setResmedium($resmedium = null)
    {
        // validation for constraint: string
        if (!is_null($resmedium) && !is_string($resmedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resmedium, true), gettype($resmedium)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($resmedium) && mb_strlen($resmedium) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($resmedium)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($resmedium) && mb_strlen($resmedium) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($resmedium)), __LINE__);
        }
        $this->resmedium = $resmedium;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\EVENT_RESERVATION
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($gdsresnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get CARD value
     * @return \StructType\CARD
     */
    public function getCARD()
    {
        return $this->CARD;
    }
    /**
     * Set CARD value
     * @param \StructType\CARD $cARD
     * @return \StructType\EVENT_RESERVATION
     */
    public function setCARD(\StructType\CARD $cARD = null)
    {
        $this->CARD = $cARD;
        return $this;
    }
    /**
     * Get ORDERER value
     * @return \StructType\ORDERER|null
     */
    public function getORDERER()
    {
        return $this->ORDERER;
    }
    /**
     * Set ORDERER value
     * @param \StructType\ORDERER $oRDERER
     * @return \StructType\EVENT_RESERVATION
     */
    public function setORDERER(\StructType\ORDERER $oRDERER = null)
    {
        $this->ORDERER = $oRDERER;
        return $this;
    }
    /**
     * Get ORDERER_CONTACT value
     * @return \StructType\ORDERER_CONTACT|null
     */
    public function getORDERER_CONTACT()
    {
        return $this->{'ORDERER-CONTACT'};
    }
    /**
     * Set ORDERER_CONTACT value
     * @param \StructType\ORDERER_CONTACT $oRDERER_CONTACT
     * @return \StructType\EVENT_RESERVATION
     */
    public function setORDERER_CONTACT(\StructType\ORDERER_CONTACT $oRDERER_CONTACT = null)
    {
        $this->ORDERER_CONTACT = $this->{'ORDERER-CONTACT'} = $oRDERER_CONTACT;
        return $this;
    }
    /**
     * Get EXTERNALID value
     * @return \StructType\EXTERNALID|null
     */
    public function getEXTERNALID()
    {
        return $this->EXTERNALID;
    }
    /**
     * Set EXTERNALID value
     * @param \StructType\EXTERNALID $eXTERNALID
     * @return \StructType\EVENT_RESERVATION
     */
    public function setEXTERNALID(\StructType\EXTERNALID $eXTERNALID = null)
    {
        $this->EXTERNALID = $eXTERNALID;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER value
     * @return \StructType\INVOICE_HOLDER[]|null
     */
    public function getINVOICE_HOLDER()
    {
        return $this->{'INVOICE-HOLDER'};
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE_HOLDER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE_HOLDER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICE_HOLDERForArrayConstraintsFromSetINVOICE_HOLDER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVENT_RESERVATIONINVOICE_HOLDERItem) {
            // validation for constraint: itemType
            if (!$eVENT_RESERVATIONINVOICE_HOLDERItem instanceof \StructType\INVOICE_HOLDER) {
                $invalidValues[] = is_object($eVENT_RESERVATIONINVOICE_HOLDERItem) ? get_class($eVENT_RESERVATIONINVOICE_HOLDERItem) : sprintf('%s(%s)', gettype($eVENT_RESERVATIONINVOICE_HOLDERItem), var_export($eVENT_RESERVATIONINVOICE_HOLDERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE_HOLDER property can only contain items of type \StructType\INVOICE_HOLDER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE_HOLDER value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE_HOLDER[] $iNVOICE_HOLDER
     * @return \StructType\EVENT_RESERVATION
     */
    public function setINVOICE_HOLDER(array $iNVOICE_HOLDER = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICE_HOLDERArrayErrorMessage = self::validateINVOICE_HOLDERForArrayConstraintsFromSetINVOICE_HOLDER($iNVOICE_HOLDER))) {
            throw new \InvalidArgumentException($iNVOICE_HOLDERArrayErrorMessage, __LINE__);
        }
        $this->INVOICE_HOLDER = $this->{'INVOICE-HOLDER'} = $iNVOICE_HOLDER;
        return $this;
    }
    /**
     * Add item to INVOICE_HOLDER value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE_HOLDER $item
     * @return \StructType\EVENT_RESERVATION
     */
    public function addToINVOICE_HOLDER(\StructType\INVOICE_HOLDER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE_HOLDER) {
            throw new \InvalidArgumentException(sprintf('The INVOICE_HOLDER property can only contain items of type \StructType\INVOICE_HOLDER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE_HOLDER[] = $this->{'INVOICE-HOLDER'}[] = $item;
        return $this;
    }
    /**
     * Get mainroom value
     * @return string|null
     */
    public function getMainroom()
    {
        return $this->mainroom;
    }
    /**
     * Set mainroom value
     * @param string $mainroom
     * @return \StructType\EVENT_RESERVATION
     */
    public function setMainroom($mainroom = null)
    {
        // validation for constraint: string
        if (!is_null($mainroom) && !is_string($mainroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainroom, true), gettype($mainroom)), __LINE__);
        }
        $this->mainroom = $mainroom;
        return $this;
    }
}
