<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositInvoice StructType
 * @subpackage Structs
 */
class DepositInvoice extends AbstractStructBase
{
    /**
     * The INVOICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_OBJID;
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicenoset
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $invoicenoset;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * Constructor method for DepositInvoice
     * @uses DepositInvoice::setINVOICE_OBJID()
     * @uses DepositInvoice::setInvoiceno()
     * @uses DepositInvoice::setInvoicenoset()
     * @uses DepositInvoice::setAmount()
     * @param string $iNVOICE_OBJID
     * @param string $invoiceno
     * @param string $invoicenoset
     * @param string $amount
     */
    public function __construct($iNVOICE_OBJID = null, $invoiceno = null, $invoicenoset = null, $amount = null)
    {
        $this
            ->setINVOICE_OBJID($iNVOICE_OBJID)
            ->setInvoiceno($invoiceno)
            ->setInvoicenoset($invoicenoset)
            ->setAmount($amount);
    }
    /**
     * Get INVOICE_OBJID value
     * @return string
     */
    public function getINVOICE_OBJID()
    {
        return $this->{'INVOICE-OBJID'};
    }
    /**
     * Set INVOICE_OBJID value
     * @param string $iNVOICE_OBJID
     * @return \StructType\DepositInvoice
     */
    public function setINVOICE_OBJID($iNVOICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_OBJID) && !is_string($iNVOICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_OBJID, true), gettype($iNVOICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_OBJID) && !preg_match('/([0-9])*/', $iNVOICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_OBJID, true)), __LINE__);
        }
        $this->INVOICE_OBJID = $this->{'INVOICE-OBJID'} = $iNVOICE_OBJID;
        return $this;
    }
    /**
     * Get invoiceno value
     * @return string
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\DepositInvoice
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicenoset value
     * @return string
     */
    public function getInvoicenoset()
    {
        return $this->invoicenoset;
    }
    /**
     * Set invoicenoset value
     * @param string $invoicenoset
     * @return \StructType\DepositInvoice
     */
    public function setInvoicenoset($invoicenoset = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoset) && !is_string($invoicenoset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoset, true), gettype($invoicenoset)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($invoicenoset)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($invoicenoset)), __LINE__);
        }
        $this->invoicenoset = $invoicenoset;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\DepositInvoice
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
