<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositInWithService StructType
 * @subpackage Structs
 */
class DepositInWithService extends AbstractStructBase
{
    /**
     * The transactionid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transactionid;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The paymentamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $paymentamount;
    /**
     * The approvalnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $approvalnumber;
    /**
     * The processingdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $processingdate;
    /**
     * The DepositInEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DepositInEntry[]
     */
    public $DepositInEntry;
    /**
     * The serviceprovider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceprovider;
    /**
     * The paymentdescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentdescription;
    /**
     * The emailfordepositinvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $emailfordepositinvoice;
    /**
     * Constructor method for DepositInWithService
     * @uses DepositInWithService::setTransactionid()
     * @uses DepositInWithService::setTypeofpayment()
     * @uses DepositInWithService::setPaymentamount()
     * @uses DepositInWithService::setApprovalnumber()
     * @uses DepositInWithService::setProcessingdate()
     * @uses DepositInWithService::setDepositInEntry()
     * @uses DepositInWithService::setServiceprovider()
     * @uses DepositInWithService::setPaymentdescription()
     * @uses DepositInWithService::setEmailfordepositinvoice()
     * @param string $transactionid
     * @param string $typeofpayment
     * @param string $paymentamount
     * @param string $approvalnumber
     * @param string $processingdate
     * @param \StructType\DepositInEntry[] $depositInEntry
     * @param string $serviceprovider
     * @param string $paymentdescription
     * @param string $emailfordepositinvoice
     */
    public function __construct($transactionid = null, $typeofpayment = null, $paymentamount = null, $approvalnumber = null, $processingdate = null, array $depositInEntry = array(), $serviceprovider = null, $paymentdescription = null, $emailfordepositinvoice = null)
    {
        $this
            ->setTransactionid($transactionid)
            ->setTypeofpayment($typeofpayment)
            ->setPaymentamount($paymentamount)
            ->setApprovalnumber($approvalnumber)
            ->setProcessingdate($processingdate)
            ->setDepositInEntry($depositInEntry)
            ->setServiceprovider($serviceprovider)
            ->setPaymentdescription($paymentdescription)
            ->setEmailfordepositinvoice($emailfordepositinvoice);
    }
    /**
     * Get transactionid value
     * @return string
     */
    public function getTransactionid()
    {
        return $this->transactionid;
    }
    /**
     * Set transactionid value
     * @param string $transactionid
     * @return \StructType\DepositInWithService
     */
    public function setTransactionid($transactionid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionid) && !is_string($transactionid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionid, true), gettype($transactionid)), __LINE__);
        }
        $this->transactionid = $transactionid;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\DepositInWithService
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get paymentamount value
     * @return string
     */
    public function getPaymentamount()
    {
        return $this->paymentamount;
    }
    /**
     * Set paymentamount value
     * @param string $paymentamount
     * @return \StructType\DepositInWithService
     */
    public function setPaymentamount($paymentamount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentamount) && !is_string($paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentamount, true), gettype($paymentamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($paymentamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($paymentamount, true)), __LINE__);
        }
        $this->paymentamount = $paymentamount;
        return $this;
    }
    /**
     * Get approvalnumber value
     * @return string
     */
    public function getApprovalnumber()
    {
        return $this->approvalnumber;
    }
    /**
     * Set approvalnumber value
     * @param string $approvalnumber
     * @return \StructType\DepositInWithService
     */
    public function setApprovalnumber($approvalnumber = null)
    {
        // validation for constraint: string
        if (!is_null($approvalnumber) && !is_string($approvalnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalnumber, true), gettype($approvalnumber)), __LINE__);
        }
        $this->approvalnumber = $approvalnumber;
        return $this;
    }
    /**
     * Get processingdate value
     * @return string
     */
    public function getProcessingdate()
    {
        return $this->processingdate;
    }
    /**
     * Set processingdate value
     * @param string $processingdate
     * @return \StructType\DepositInWithService
     */
    public function setProcessingdate($processingdate = null)
    {
        // validation for constraint: string
        if (!is_null($processingdate) && !is_string($processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingdate, true), gettype($processingdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($processingdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($processingdate, true)), __LINE__);
        }
        $this->processingdate = $processingdate;
        return $this;
    }
    /**
     * Get DepositInEntry value
     * @return \StructType\DepositInEntry[]
     */
    public function getDepositInEntry()
    {
        return $this->DepositInEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositInEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositInEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositInEntryForArrayConstraintsFromSetDepositInEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depositInWithServiceDepositInEntryItem) {
            // validation for constraint: itemType
            if (!$depositInWithServiceDepositInEntryItem instanceof \StructType\DepositInEntry) {
                $invalidValues[] = is_object($depositInWithServiceDepositInEntryItem) ? get_class($depositInWithServiceDepositInEntryItem) : sprintf('%s(%s)', gettype($depositInWithServiceDepositInEntryItem), var_export($depositInWithServiceDepositInEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepositInEntry property can only contain items of type \StructType\DepositInEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepositInEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositInEntry[] $depositInEntry
     * @return \StructType\DepositInWithService
     */
    public function setDepositInEntry(array $depositInEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($depositInEntryArrayErrorMessage = self::validateDepositInEntryForArrayConstraintsFromSetDepositInEntry($depositInEntry))) {
            throw new \InvalidArgumentException($depositInEntryArrayErrorMessage, __LINE__);
        }
        $this->DepositInEntry = $depositInEntry;
        return $this;
    }
    /**
     * Add item to DepositInEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositInEntry $item
     * @return \StructType\DepositInWithService
     */
    public function addToDepositInEntry(\StructType\DepositInEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositInEntry) {
            throw new \InvalidArgumentException(sprintf('The DepositInEntry property can only contain items of type \StructType\DepositInEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DepositInEntry[] = $item;
        return $this;
    }
    /**
     * Get serviceprovider value
     * @return string|null
     */
    public function getServiceprovider()
    {
        return $this->serviceprovider;
    }
    /**
     * Set serviceprovider value
     * @param string $serviceprovider
     * @return \StructType\DepositInWithService
     */
    public function setServiceprovider($serviceprovider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceprovider) && !is_string($serviceprovider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceprovider, true), gettype($serviceprovider)), __LINE__);
        }
        $this->serviceprovider = $serviceprovider;
        return $this;
    }
    /**
     * Get paymentdescription value
     * @return string|null
     */
    public function getPaymentdescription()
    {
        return $this->paymentdescription;
    }
    /**
     * Set paymentdescription value
     * @param string $paymentdescription
     * @return \StructType\DepositInWithService
     */
    public function setPaymentdescription($paymentdescription = null)
    {
        // validation for constraint: string
        if (!is_null($paymentdescription) && !is_string($paymentdescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentdescription, true), gettype($paymentdescription)), __LINE__);
        }
        $this->paymentdescription = $paymentdescription;
        return $this;
    }
    /**
     * Get emailfordepositinvoice value
     * @return string|null
     */
    public function getEmailfordepositinvoice()
    {
        return $this->emailfordepositinvoice;
    }
    /**
     * Set emailfordepositinvoice value
     * @param string $emailfordepositinvoice
     * @return \StructType\DepositInWithService
     */
    public function setEmailfordepositinvoice($emailfordepositinvoice = null)
    {
        // validation for constraint: string
        if (!is_null($emailfordepositinvoice) && !is_string($emailfordepositinvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailfordepositinvoice, true), gettype($emailfordepositinvoice)), __LINE__);
        }
        $this->emailfordepositinvoice = $emailfordepositinvoice;
        return $this;
    }
}
