<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositInWithForecast StructType
 * @subpackage Structs
 */
class DepositInWithForecast extends AbstractStructBase
{
    /**
     * The transactionid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transactionid;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The approvalnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $approvalnumber;
    /**
     * The processingdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $processingdate;
    /**
     * The paymentinstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentinstructions;
    /**
     * The paymentamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $paymentamount;
    /**
     * The serviceprovider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceprovider;
    /**
     * The paymentdescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentdescription;
    /**
     * The emailfordepositinvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $emailfordepositinvoice;
    /**
     * Constructor method for DepositInWithForecast
     * @uses DepositInWithForecast::setTransactionid()
     * @uses DepositInWithForecast::setTypeofpayment()
     * @uses DepositInWithForecast::setApprovalnumber()
     * @uses DepositInWithForecast::setProcessingdate()
     * @uses DepositInWithForecast::setPaymentinstructions()
     * @uses DepositInWithForecast::setPaymentamount()
     * @uses DepositInWithForecast::setServiceprovider()
     * @uses DepositInWithForecast::setPaymentdescription()
     * @uses DepositInWithForecast::setEmailfordepositinvoice()
     * @param string $transactionid
     * @param string $typeofpayment
     * @param string $approvalnumber
     * @param string $processingdate
     * @param string $paymentinstructions
     * @param string $paymentamount
     * @param string $serviceprovider
     * @param string $paymentdescription
     * @param string $emailfordepositinvoice
     */
    public function __construct($transactionid = null, $typeofpayment = null, $approvalnumber = null, $processingdate = null, $paymentinstructions = null, $paymentamount = null, $serviceprovider = null, $paymentdescription = null, $emailfordepositinvoice = null)
    {
        $this
            ->setTransactionid($transactionid)
            ->setTypeofpayment($typeofpayment)
            ->setApprovalnumber($approvalnumber)
            ->setProcessingdate($processingdate)
            ->setPaymentinstructions($paymentinstructions)
            ->setPaymentamount($paymentamount)
            ->setServiceprovider($serviceprovider)
            ->setPaymentdescription($paymentdescription)
            ->setEmailfordepositinvoice($emailfordepositinvoice);
    }
    /**
     * Get transactionid value
     * @return string
     */
    public function getTransactionid()
    {
        return $this->transactionid;
    }
    /**
     * Set transactionid value
     * @param string $transactionid
     * @return \StructType\DepositInWithForecast
     */
    public function setTransactionid($transactionid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionid) && !is_string($transactionid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionid, true), gettype($transactionid)), __LINE__);
        }
        $this->transactionid = $transactionid;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\DepositInWithForecast
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get approvalnumber value
     * @return string
     */
    public function getApprovalnumber()
    {
        return $this->approvalnumber;
    }
    /**
     * Set approvalnumber value
     * @param string $approvalnumber
     * @return \StructType\DepositInWithForecast
     */
    public function setApprovalnumber($approvalnumber = null)
    {
        // validation for constraint: string
        if (!is_null($approvalnumber) && !is_string($approvalnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalnumber, true), gettype($approvalnumber)), __LINE__);
        }
        $this->approvalnumber = $approvalnumber;
        return $this;
    }
    /**
     * Get processingdate value
     * @return string
     */
    public function getProcessingdate()
    {
        return $this->processingdate;
    }
    /**
     * Set processingdate value
     * @param string $processingdate
     * @return \StructType\DepositInWithForecast
     */
    public function setProcessingdate($processingdate = null)
    {
        // validation for constraint: string
        if (!is_null($processingdate) && !is_string($processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingdate, true), gettype($processingdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($processingdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($processingdate, true)), __LINE__);
        }
        $this->processingdate = $processingdate;
        return $this;
    }
    /**
     * Get paymentinstructions value
     * @return string
     */
    public function getPaymentinstructions()
    {
        return $this->paymentinstructions;
    }
    /**
     * Set paymentinstructions value
     * @param string $paymentinstructions
     * @return \StructType\DepositInWithForecast
     */
    public function setPaymentinstructions($paymentinstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentinstructions) && !is_string($paymentinstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentinstructions, true), gettype($paymentinstructions)), __LINE__);
        }
        $this->paymentinstructions = $paymentinstructions;
        return $this;
    }
    /**
     * Get paymentamount value
     * @return string|null
     */
    public function getPaymentamount()
    {
        return $this->paymentamount;
    }
    /**
     * Set paymentamount value
     * @param string $paymentamount
     * @return \StructType\DepositInWithForecast
     */
    public function setPaymentamount($paymentamount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentamount) && !is_string($paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentamount, true), gettype($paymentamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($paymentamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($paymentamount, true)), __LINE__);
        }
        $this->paymentamount = $paymentamount;
        return $this;
    }
    /**
     * Get serviceprovider value
     * @return string|null
     */
    public function getServiceprovider()
    {
        return $this->serviceprovider;
    }
    /**
     * Set serviceprovider value
     * @param string $serviceprovider
     * @return \StructType\DepositInWithForecast
     */
    public function setServiceprovider($serviceprovider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceprovider) && !is_string($serviceprovider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceprovider, true), gettype($serviceprovider)), __LINE__);
        }
        $this->serviceprovider = $serviceprovider;
        return $this;
    }
    /**
     * Get paymentdescription value
     * @return string|null
     */
    public function getPaymentdescription()
    {
        return $this->paymentdescription;
    }
    /**
     * Set paymentdescription value
     * @param string $paymentdescription
     * @return \StructType\DepositInWithForecast
     */
    public function setPaymentdescription($paymentdescription = null)
    {
        // validation for constraint: string
        if (!is_null($paymentdescription) && !is_string($paymentdescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentdescription, true), gettype($paymentdescription)), __LINE__);
        }
        $this->paymentdescription = $paymentdescription;
        return $this;
    }
    /**
     * Get emailfordepositinvoice value
     * @return string|null
     */
    public function getEmailfordepositinvoice()
    {
        return $this->emailfordepositinvoice;
    }
    /**
     * Set emailfordepositinvoice value
     * @param string $emailfordepositinvoice
     * @return \StructType\DepositInWithForecast
     */
    public function setEmailfordepositinvoice($emailfordepositinvoice = null)
    {
        // validation for constraint: string
        if (!is_null($emailfordepositinvoice) && !is_string($emailfordepositinvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailfordepositinvoice, true), gettype($emailfordepositinvoice)), __LINE__);
        }
        $this->emailfordepositinvoice = $emailfordepositinvoice;
        return $this;
    }
}
