<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DISCOUNT-SEARCH StructType
 * @subpackage Structs
 */
class DISCOUNT_SEARCH extends AbstractStructBase
{
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $discountgroup;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicetype;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicecode;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratecategory;
    /**
     * The ratefilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratefilter;
    /**
     * Constructor method for DISCOUNT-SEARCH
     * @uses DISCOUNT_SEARCH::setDatefrom()
     * @uses DISCOUNT_SEARCH::setDateto()
     * @uses DISCOUNT_SEARCH::setDiscountgroup()
     * @uses DISCOUNT_SEARCH::setServicetype()
     * @uses DISCOUNT_SEARCH::setServicecode()
     * @uses DISCOUNT_SEARCH::setRatesegment()
     * @uses DISCOUNT_SEARCH::setRatecategory()
     * @uses DISCOUNT_SEARCH::setRatefilter()
     * @param string $datefrom
     * @param string $dateto
     * @param string $discountgroup
     * @param string $servicetype
     * @param string $servicecode
     * @param string $ratesegment
     * @param string $ratecategory
     * @param string $ratefilter
     */
    public function __construct($datefrom = null, $dateto = null, $discountgroup = null, $servicetype = null, $servicecode = null, $ratesegment = null, $ratecategory = null, $ratefilter = null)
    {
        $this
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setDiscountgroup($discountgroup)
            ->setServicetype($servicetype)
            ->setServicecode($servicecode)
            ->setRatesegment($ratesegment)
            ->setRatecategory($ratecategory)
            ->setRatefilter($ratefilter);
    }
    /**
     * Get datefrom value
     * @return string|null
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string|null
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string|null
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string|null
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string|null
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string|null
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratefilter value
     * @return string|null
     */
    public function getRatefilter()
    {
        return $this->ratefilter;
    }
    /**
     * Set ratefilter value
     * @param string $ratefilter
     * @return \StructType\DISCOUNT_SEARCH
     */
    public function setRatefilter($ratefilter = null)
    {
        // validation for constraint: string
        if (!is_null($ratefilter) && !is_string($ratefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratefilter, true), gettype($ratefilter)), __LINE__);
        }
        $this->ratefilter = $ratefilter;
        return $this;
    }
}
