<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DEPARTURE StructType
 * @subpackage Structs
 */
class DEPARTURE extends AbstractStructBase
{
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $departure;
    /**
     * The departuretime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $departuretime;
    /**
     * The tooltip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tooltip;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The vipdeparture
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vipdeparture;
    /**
     * The amenities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $amenities;
    /**
     * Constructor method for DEPARTURE
     * @uses DEPARTURE::setDeparture()
     * @uses DEPARTURE::setDeparturetime()
     * @uses DEPARTURE::setTooltip()
     * @uses DEPARTURE::setComment()
     * @uses DEPARTURE::setVipdeparture()
     * @uses DEPARTURE::setAmenities()
     * @param string $departure
     * @param string $departuretime
     * @param string $tooltip
     * @param string $comment
     * @param string $vipdeparture
     * @param string $amenities
     */
    public function __construct($departure = null, $departuretime = null, $tooltip = null, $comment = null, $vipdeparture = null, $amenities = null)
    {
        $this
            ->setDeparture($departure)
            ->setDeparturetime($departuretime)
            ->setTooltip($tooltip)
            ->setComment($comment)
            ->setVipdeparture($vipdeparture)
            ->setAmenities($amenities);
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\DEPARTURE
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get departuretime value
     * @return string
     */
    public function getDeparturetime()
    {
        return $this->departuretime;
    }
    /**
     * Set departuretime value
     * @param string $departuretime
     * @return \StructType\DEPARTURE
     */
    public function setDeparturetime($departuretime = null)
    {
        // validation for constraint: string
        if (!is_null($departuretime) && !is_string($departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departuretime, true), gettype($departuretime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($departuretime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($departuretime, true)), __LINE__);
        }
        $this->departuretime = $departuretime;
        return $this;
    }
    /**
     * Get tooltip value
     * @return string
     */
    public function getTooltip()
    {
        return $this->tooltip;
    }
    /**
     * Set tooltip value
     * @param string $tooltip
     * @return \StructType\DEPARTURE
     */
    public function setTooltip($tooltip = null)
    {
        // validation for constraint: string
        if (!is_null($tooltip) && !is_string($tooltip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tooltip, true), gettype($tooltip)), __LINE__);
        }
        $this->tooltip = $tooltip;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\DEPARTURE
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get vipdeparture value
     * @return string
     */
    public function getVipdeparture()
    {
        return $this->vipdeparture;
    }
    /**
     * Set vipdeparture value
     * @param string $vipdeparture
     * @return \StructType\DEPARTURE
     */
    public function setVipdeparture($vipdeparture = null)
    {
        // validation for constraint: string
        if (!is_null($vipdeparture) && !is_string($vipdeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vipdeparture, true), gettype($vipdeparture)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vipdeparture) && mb_strlen($vipdeparture) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vipdeparture)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vipdeparture) && mb_strlen($vipdeparture) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vipdeparture)), __LINE__);
        }
        $this->vipdeparture = $vipdeparture;
        return $this;
    }
    /**
     * Get amenities value
     * @return string
     */
    public function getAmenities()
    {
        return $this->amenities;
    }
    /**
     * Set amenities value
     * @param string $amenities
     * @return \StructType\DEPARTURE
     */
    public function setAmenities($amenities = null)
    {
        // validation for constraint: string
        if (!is_null($amenities) && !is_string($amenities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenities, true), gettype($amenities)), __LINE__);
        }
        $this->amenities = $amenities;
        return $this;
    }
}
