<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryMasterFile StructType
 * @subpackage Structs
 */
class CategoryMasterFile extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The descriptionDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descriptionDefault;
    /**
     * The commentDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commentDefault;
    /**
     * The sorting
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $sorting;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Images[]
     */
    public $Images;
    /**
     * Constructor method for CategoryMasterFile
     * @uses CategoryMasterFile::setDescription()
     * @uses CategoryMasterFile::setComment()
     * @uses CategoryMasterFile::setDescriptionDefault()
     * @uses CategoryMasterFile::setCommentDefault()
     * @uses CategoryMasterFile::setSorting()
     * @uses CategoryMasterFile::setImages()
     * @param string $description
     * @param string $comment
     * @param string $descriptionDefault
     * @param string $commentDefault
     * @param string $sorting
     * @param \StructType\Images[] $images
     */
    public function __construct($description = null, $comment = null, $descriptionDefault = null, $commentDefault = null, $sorting = null, array $images = array())
    {
        $this
            ->setDescription($description)
            ->setComment($comment)
            ->setDescriptionDefault($descriptionDefault)
            ->setCommentDefault($commentDefault)
            ->setSorting($sorting)
            ->setImages($images);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CategoryMasterFile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\CategoryMasterFile
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get descriptionDefault value
     * @return string
     */
    public function getDescriptionDefault()
    {
        return $this->descriptionDefault;
    }
    /**
     * Set descriptionDefault value
     * @param string $descriptionDefault
     * @return \StructType\CategoryMasterFile
     */
    public function setDescriptionDefault($descriptionDefault = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionDefault) && !is_string($descriptionDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionDefault, true), gettype($descriptionDefault)), __LINE__);
        }
        $this->descriptionDefault = $descriptionDefault;
        return $this;
    }
    /**
     * Get commentDefault value
     * @return string
     */
    public function getCommentDefault()
    {
        return $this->commentDefault;
    }
    /**
     * Set commentDefault value
     * @param string $commentDefault
     * @return \StructType\CategoryMasterFile
     */
    public function setCommentDefault($commentDefault = null)
    {
        // validation for constraint: string
        if (!is_null($commentDefault) && !is_string($commentDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDefault, true), gettype($commentDefault)), __LINE__);
        }
        $this->commentDefault = $commentDefault;
        return $this;
    }
    /**
     * Get sorting value
     * @return string
     */
    public function getSorting()
    {
        return $this->sorting;
    }
    /**
     * Set sorting value
     * @param string $sorting
     * @return \StructType\CategoryMasterFile
     */
    public function setSorting($sorting = null)
    {
        // validation for constraint: string
        if (!is_null($sorting) && !is_string($sorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sorting, true), gettype($sorting)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sorting) && mb_strlen($sorting) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sorting)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($sorting) && mb_strlen($sorting) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($sorting)), __LINE__);
        }
        $this->sorting = $sorting;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\Images[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryMasterFileImagesItem) {
            // validation for constraint: itemType
            if (!$categoryMasterFileImagesItem instanceof \StructType\Images) {
                $invalidValues[] = is_object($categoryMasterFileImagesItem) ? get_class($categoryMasterFileImagesItem) : sprintf('%s(%s)', gettype($categoryMasterFileImagesItem), var_export($categoryMasterFileImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images[] $images
     * @return \StructType\CategoryMasterFile
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images $item
     * @return \StructType\CategoryMasterFile
     */
    public function addToImages(\StructType\Images $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Images) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
}
