<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CBModuleMasterFile StructType
 * @subpackage Structs
 */
class CBModuleMasterFile extends AbstractStructBase
{
    /**
     * The EVENT_CB_MOUDLE_MASTER_FILE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_CB_MOUDLE_MASTER_FILE_OBJID;
    /**
     * The cbmoduleid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $cbmoduleid;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The MultiLangDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangDescriptions[]
     */
    public $MultiLangDescriptions;
    /**
     * The MultiLangComments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments[]
     */
    public $MultiLangComments;
    /**
     * Constructor method for CBModuleMasterFile
     * @uses CBModuleMasterFile::setEVENT_CB_MOUDLE_MASTER_FILE_OBJID()
     * @uses CBModuleMasterFile::setCbmoduleid()
     * @uses CBModuleMasterFile::setHotel()
     * @uses CBModuleMasterFile::setMultiLangDescriptions()
     * @uses CBModuleMasterFile::setMultiLangComments()
     * @param string $eVENT_CB_MOUDLE_MASTER_FILE_OBJID
     * @param string $cbmoduleid
     * @param string $hotel
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @param \StructType\MultiLangComments[] $multiLangComments
     */
    public function __construct($eVENT_CB_MOUDLE_MASTER_FILE_OBJID = null, $cbmoduleid = null, $hotel = null, array $multiLangDescriptions = array(), array $multiLangComments = array())
    {
        $this
            ->setEVENT_CB_MOUDLE_MASTER_FILE_OBJID($eVENT_CB_MOUDLE_MASTER_FILE_OBJID)
            ->setCbmoduleid($cbmoduleid)
            ->setHotel($hotel)
            ->setMultiLangDescriptions($multiLangDescriptions)
            ->setMultiLangComments($multiLangComments);
    }
    /**
     * Get EVENT_CB_MOUDLE_MASTER_FILE_OBJID value
     * @return string
     */
    public function getEVENT_CB_MOUDLE_MASTER_FILE_OBJID()
    {
        return $this->{'EVENT-CB-MOUDLE-MASTER-FILE-OBJID'};
    }
    /**
     * Set EVENT_CB_MOUDLE_MASTER_FILE_OBJID value
     * @param string $eVENT_CB_MOUDLE_MASTER_FILE_OBJID
     * @return \StructType\CBModuleMasterFile
     */
    public function setEVENT_CB_MOUDLE_MASTER_FILE_OBJID($eVENT_CB_MOUDLE_MASTER_FILE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_CB_MOUDLE_MASTER_FILE_OBJID) && !is_string($eVENT_CB_MOUDLE_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_CB_MOUDLE_MASTER_FILE_OBJID, true), gettype($eVENT_CB_MOUDLE_MASTER_FILE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_CB_MOUDLE_MASTER_FILE_OBJID) && !preg_match('/([0-9])*/', $eVENT_CB_MOUDLE_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_CB_MOUDLE_MASTER_FILE_OBJID, true)), __LINE__);
        }
        $this->EVENT_CB_MOUDLE_MASTER_FILE_OBJID = $this->{'EVENT-CB-MOUDLE-MASTER-FILE-OBJID'} = $eVENT_CB_MOUDLE_MASTER_FILE_OBJID;
        return $this;
    }
    /**
     * Get cbmoduleid value
     * @return string
     */
    public function getCbmoduleid()
    {
        return $this->cbmoduleid;
    }
    /**
     * Set cbmoduleid value
     * @param string $cbmoduleid
     * @return \StructType\CBModuleMasterFile
     */
    public function setCbmoduleid($cbmoduleid = null)
    {
        // validation for constraint: string
        if (!is_null($cbmoduleid) && !is_string($cbmoduleid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cbmoduleid, true), gettype($cbmoduleid)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cbmoduleid) && mb_strlen($cbmoduleid) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cbmoduleid)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cbmoduleid) && mb_strlen($cbmoduleid) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cbmoduleid)), __LINE__);
        }
        $this->cbmoduleid = $cbmoduleid;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\CBModuleMasterFile
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get MultiLangDescriptions value
     * @return \StructType\MultiLangDescriptions[]|null
     */
    public function getMultiLangDescriptions()
    {
        return $this->MultiLangDescriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cBModuleMasterFileMultiLangDescriptionsItem) {
            // validation for constraint: itemType
            if (!$cBModuleMasterFileMultiLangDescriptionsItem instanceof \StructType\MultiLangDescriptions) {
                $invalidValues[] = is_object($cBModuleMasterFileMultiLangDescriptionsItem) ? get_class($cBModuleMasterFileMultiLangDescriptionsItem) : sprintf('%s(%s)', gettype($cBModuleMasterFileMultiLangDescriptionsItem), var_export($cBModuleMasterFileMultiLangDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @return \StructType\CBModuleMasterFile
     */
    public function setMultiLangDescriptions(array $multiLangDescriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangDescriptionsArrayErrorMessage = self::validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions($multiLangDescriptions))) {
            throw new \InvalidArgumentException($multiLangDescriptionsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangDescriptions = $multiLangDescriptions;
        return $this;
    }
    /**
     * Add item to MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions $item
     * @return \StructType\CBModuleMasterFile
     */
    public function addToMultiLangDescriptions(\StructType\MultiLangDescriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangDescriptions) {
            throw new \InvalidArgumentException(sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangDescriptions[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments value
     * @return \StructType\MultiLangComments[]|null
     */
    public function getMultiLangComments()
    {
        return $this->MultiLangComments;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cBModuleMasterFileMultiLangCommentsItem) {
            // validation for constraint: itemType
            if (!$cBModuleMasterFileMultiLangCommentsItem instanceof \StructType\MultiLangComments) {
                $invalidValues[] = is_object($cBModuleMasterFileMultiLangCommentsItem) ? get_class($cBModuleMasterFileMultiLangCommentsItem) : sprintf('%s(%s)', gettype($cBModuleMasterFileMultiLangCommentsItem), var_export($cBModuleMasterFileMultiLangCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @return \StructType\CBModuleMasterFile
     */
    public function setMultiLangComments(array $multiLangComments = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangCommentsArrayErrorMessage = self::validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments($multiLangComments))) {
            throw new \InvalidArgumentException($multiLangCommentsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments = $multiLangComments;
        return $this;
    }
    /**
     * Add item to MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments $item
     * @return \StructType\CBModuleMasterFile
     */
    public function addToMultiLangComments(\StructType\MultiLangComments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments[] = $item;
        return $this;
    }
}
