<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingstate StructType
 * @subpackage Structs
 */
class Bookingstate extends AbstractStructBase
{
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The bookingdata
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Bookingdata[]
     */
    public $bookingdata;
    /**
     * Constructor method for bookingstate
     * @uses Bookingstate::setROOM_OBJID()
     * @uses Bookingstate::setRoom()
     * @uses Bookingstate::setStatus()
     * @uses Bookingstate::setBookingdata()
     * @param string $rOOM_OBJID
     * @param string $room
     * @param string $status
     * @param \StructType\Bookingdata[] $bookingdata
     */
    public function __construct($rOOM_OBJID = null, $room = null, $status = null, array $bookingdata = array())
    {
        $this
            ->setROOM_OBJID($rOOM_OBJID)
            ->setRoom($room)
            ->setStatus($status)
            ->setBookingdata($bookingdata);
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\Bookingstate
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\Bookingstate
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Bookingstate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get bookingdata value
     * @return \StructType\Bookingdata[]|null
     */
    public function getBookingdata()
    {
        return $this->bookingdata;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingdata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingdata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingdataForArrayConstraintsFromSetBookingdata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingstateBookingdataItem) {
            // validation for constraint: itemType
            if (!$bookingstateBookingdataItem instanceof \StructType\Bookingdata) {
                $invalidValues[] = is_object($bookingstateBookingdataItem) ? get_class($bookingstateBookingdataItem) : sprintf('%s(%s)', gettype($bookingstateBookingdataItem), var_export($bookingstateBookingdataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bookingdata property can only contain items of type \StructType\Bookingdata, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bookingdata value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingdata[] $bookingdata
     * @return \StructType\Bookingstate
     */
    public function setBookingdata(array $bookingdata = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingdataArrayErrorMessage = self::validateBookingdataForArrayConstraintsFromSetBookingdata($bookingdata))) {
            throw new \InvalidArgumentException($bookingdataArrayErrorMessage, __LINE__);
        }
        $this->bookingdata = $bookingdata;
        return $this;
    }
    /**
     * Add item to bookingdata value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingdata $item
     * @return \StructType\Bookingstate
     */
    public function addToBookingdata(\StructType\Bookingdata $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingdata) {
            throw new \InvalidArgumentException(sprintf('The bookingdata property can only contain items of type \StructType\Bookingdata, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bookingdata[] = $item;
        return $this;
    }
}
