<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoTaskSetError StructType
 * @subpackage Structs
 */
class AutoTaskSetError extends AbstractStructBase
{
    /**
     * The AUTOTASK_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $AUTOTASK_OBJID;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorMsg;
    /**
     * The SysMessage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $SysMessage;
    /**
     * Constructor method for AutoTaskSetError
     * @uses AutoTaskSetError::setAUTOTASK_OBJID()
     * @uses AutoTaskSetError::setErrorMsg()
     * @uses AutoTaskSetError::setSysMessage()
     * @param string $aUTOTASK_OBJID
     * @param string $errorMsg
     * @param string $sysMessage
     */
    public function __construct($aUTOTASK_OBJID = null, $errorMsg = null, $sysMessage = null)
    {
        $this
            ->setAUTOTASK_OBJID($aUTOTASK_OBJID)
            ->setErrorMsg($errorMsg)
            ->setSysMessage($sysMessage);
    }
    /**
     * Get AUTOTASK_OBJID value
     * @return string
     */
    public function getAUTOTASK_OBJID()
    {
        return $this->{'AUTOTASK-OBJID'};
    }
    /**
     * Set AUTOTASK_OBJID value
     * @param string $aUTOTASK_OBJID
     * @return \StructType\AutoTaskSetError
     */
    public function setAUTOTASK_OBJID($aUTOTASK_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aUTOTASK_OBJID) && !is_string($aUTOTASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUTOTASK_OBJID, true), gettype($aUTOTASK_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aUTOTASK_OBJID) && !preg_match('/([0-9])*/', $aUTOTASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aUTOTASK_OBJID, true)), __LINE__);
        }
        $this->AUTOTASK_OBJID = $this->{'AUTOTASK-OBJID'} = $aUTOTASK_OBJID;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \StructType\AutoTaskSetError
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get SysMessage value
     * @return string|null
     */
    public function getSysMessage()
    {
        return $this->SysMessage;
    }
    /**
     * Set SysMessage value
     * @param string $sysMessage
     * @return \StructType\AutoTaskSetError
     */
    public function setSysMessage($sysMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sysMessage) && !is_string($sysMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sysMessage, true), gettype($sysMessage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($sysMessage) && !preg_match('/([-+]){0,1}([0-9])*/', $sysMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($sysMessage, true)), __LINE__);
        }
        $this->SysMessage = $sysMessage;
        return $this;
    }
}
