<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoTaskConfirm StructType
 * @subpackage Structs
 */
class AutoTaskConfirm extends AbstractStructBase
{
    /**
     * The AUTOTASK_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $AUTOTASK_OBJID;
    /**
     * Constructor method for AutoTaskConfirm
     * @uses AutoTaskConfirm::setAUTOTASK_OBJID()
     * @param string $aUTOTASK_OBJID
     */
    public function __construct($aUTOTASK_OBJID = null)
    {
        $this
            ->setAUTOTASK_OBJID($aUTOTASK_OBJID);
    }
    /**
     * Get AUTOTASK_OBJID value
     * @return string
     */
    public function getAUTOTASK_OBJID()
    {
        return $this->{'AUTOTASK-OBJID'};
    }
    /**
     * Set AUTOTASK_OBJID value
     * @param string $aUTOTASK_OBJID
     * @return \StructType\AutoTaskConfirm
     */
    public function setAUTOTASK_OBJID($aUTOTASK_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aUTOTASK_OBJID) && !is_string($aUTOTASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUTOTASK_OBJID, true), gettype($aUTOTASK_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aUTOTASK_OBJID) && !preg_match('/([0-9])*/', $aUTOTASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aUTOTASK_OBJID, true)), __LINE__);
        }
        $this->AUTOTASK_OBJID = $this->{'AUTOTASK-OBJID'} = $aUTOTASK_OBJID;
        return $this;
    }
}
