<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationInfos StructType
 * @subpackage Structs
 */
class AuthenticationInfos extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $user;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $password;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The hoteldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $hoteldate;
    /**
     * The useldap
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $useldap;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * Constructor method for AuthenticationInfos
     * @uses AuthenticationInfos::setUser()
     * @uses AuthenticationInfos::setPassword()
     * @uses AuthenticationInfos::setHotel()
     * @uses AuthenticationInfos::setHoteldate()
     * @uses AuthenticationInfos::setUseldap()
     * @uses AuthenticationInfos::setProduct()
     * @param string $user
     * @param string $password
     * @param string $hotel
     * @param string $hoteldate
     * @param string $useldap
     * @param string $product
     */
    public function __construct($user = null, $password = null, $hotel = null, $hoteldate = null, $useldap = null, $product = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setHotel($hotel)
            ->setHoteldate($hoteldate)
            ->setUseldap($useldap)
            ->setProduct($product);
    }
    /**
     * Get user value
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\AuthenticationInfos
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthenticationInfos
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get hotel value
     * @return string|null
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\AuthenticationInfos
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get hoteldate value
     * @return string|null
     */
    public function getHoteldate()
    {
        return $this->hoteldate;
    }
    /**
     * Set hoteldate value
     * @param string $hoteldate
     * @return \StructType\AuthenticationInfos
     */
    public function setHoteldate($hoteldate = null)
    {
        // validation for constraint: string
        if (!is_null($hoteldate) && !is_string($hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoteldate, true), gettype($hoteldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($hoteldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($hoteldate, true)), __LINE__);
        }
        $this->hoteldate = $hoteldate;
        return $this;
    }
    /**
     * Get useldap value
     * @return string|null
     */
    public function getUseldap()
    {
        return $this->useldap;
    }
    /**
     * Set useldap value
     * @param string $useldap
     * @return \StructType\AuthenticationInfos
     */
    public function setUseldap($useldap = null)
    {
        // validation for constraint: string
        if (!is_null($useldap) && !is_string($useldap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useldap, true), gettype($useldap)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($useldap) && !preg_match('/([-+]){0,1}([0-9])*/', $useldap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($useldap, true)), __LINE__);
        }
        $this->useldap = $useldap;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\AuthenticationInfos
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
}
