<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllowedHotel StructType
 * @subpackage Structs
 */
class AllowedHotel extends AbstractStructBase
{
    /**
     * The hotelNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelNo;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The codeInternal
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $codeInternal;
    /**
     * Constructor method for AllowedHotel
     * @uses AllowedHotel::setHotelNo()
     * @uses AllowedHotel::setName()
     * @uses AllowedHotel::setCodeInternal()
     * @param string $hotelNo
     * @param string $name
     * @param string $codeInternal
     */
    public function __construct($hotelNo = null, $name = null, $codeInternal = null)
    {
        $this
            ->setHotelNo($hotelNo)
            ->setName($name)
            ->setCodeInternal($codeInternal);
    }
    /**
     * Get hotelNo value
     * @return string
     */
    public function getHotelNo()
    {
        return $this->hotelNo;
    }
    /**
     * Set hotelNo value
     * @param string $hotelNo
     * @return \StructType\AllowedHotel
     */
    public function setHotelNo($hotelNo = null)
    {
        // validation for constraint: string
        if (!is_null($hotelNo) && !is_string($hotelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelNo, true), gettype($hotelNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelNo) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelNo, true)), __LINE__);
        }
        $this->hotelNo = $hotelNo;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AllowedHotel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get codeInternal value
     * @return string
     */
    public function getCodeInternal()
    {
        return $this->codeInternal;
    }
    /**
     * Set codeInternal value
     * @param string $codeInternal
     * @return \StructType\AllowedHotel
     */
    public function setCodeInternal($codeInternal = null)
    {
        // validation for constraint: string
        if (!is_null($codeInternal) && !is_string($codeInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeInternal, true), gettype($codeInternal)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($codeInternal) && mb_strlen($codeInternal) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($codeInternal)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($codeInternal) && mb_strlen($codeInternal) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($codeInternal)), __LINE__);
        }
        $this->codeInternal = $codeInternal;
        return $this;
    }
}
