<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account_1 extends AbstractStructBase
{
    /**
     * The ACOOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACOOUNT_OBJID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * The accountno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $accountno;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $credit;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $debit;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $balance;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The eventno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $eventno;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * The creditlimit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $creditlimit;
    /**
     * The nopost
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $nopost;
    /**
     * The paymentlink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentlink;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Owner[]
     */
    public $Owner;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room[]
     */
    public $Room;
    /**
     * Constructor method for Account
     * @uses Account_1::setACOOUNT_OBJID()
     * @uses Account_1::setAccounttype()
     * @uses Account_1::setAccountno()
     * @uses Account_1::setStatus()
     * @uses Account_1::setCredit()
     * @uses Account_1::setDebit()
     * @uses Account_1::setBalance()
     * @uses Account_1::setResno()
     * @uses Account_1::setEventno()
     * @uses Account_1::setArrival()
     * @uses Account_1::setDeparture()
     * @uses Account_1::setACCOUNT_OBJID()
     * @uses Account_1::setCreditlimit()
     * @uses Account_1::setNopost()
     * @uses Account_1::setPaymentlink()
     * @uses Account_1::setOwner()
     * @uses Account_1::setRoom()
     * @param string $aCOOUNT_OBJID
     * @param string $accounttype
     * @param string $accountno
     * @param string $status
     * @param string $credit
     * @param string $debit
     * @param string $balance
     * @param string $resno
     * @param string $eventno
     * @param string $arrival
     * @param string $departure
     * @param string $aCCOUNT_OBJID
     * @param string $creditlimit
     * @param string $nopost
     * @param string $paymentlink
     * @param \StructType\Owner[] $owner
     * @param \StructType\Room[] $room
     */
    public function __construct($aCOOUNT_OBJID = null, $accounttype = null, $accountno = null, $status = null, $credit = null, $debit = null, $balance = null, $resno = null, $eventno = null, $arrival = null, $departure = null, $aCCOUNT_OBJID = null, $creditlimit = null, $nopost = null, $paymentlink = null, array $owner = array(), array $room = array())
    {
        $this
            ->setACOOUNT_OBJID($aCOOUNT_OBJID)
            ->setAccounttype($accounttype)
            ->setAccountno($accountno)
            ->setStatus($status)
            ->setCredit($credit)
            ->setDebit($debit)
            ->setBalance($balance)
            ->setResno($resno)
            ->setEventno($eventno)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setACCOUNT_OBJID($aCCOUNT_OBJID)
            ->setCreditlimit($creditlimit)
            ->setNopost($nopost)
            ->setPaymentlink($paymentlink)
            ->setOwner($owner)
            ->setRoom($room);
    }
    /**
     * Get ACOOUNT_OBJID value
     * @return string
     */
    public function getACOOUNT_OBJID()
    {
        return $this->{'ACOOUNT-OBJID'};
    }
    /**
     * Set ACOOUNT_OBJID value
     * @param string $aCOOUNT_OBJID
     * @return \StructType\Account_1
     */
    public function setACOOUNT_OBJID($aCOOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCOOUNT_OBJID) && !is_string($aCOOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCOOUNT_OBJID, true), gettype($aCOOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCOOUNT_OBJID) && !preg_match('/([0-9])*/', $aCOOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCOOUNT_OBJID, true)), __LINE__);
        }
        $this->ACOOUNT_OBJID = $this->{'ACOOUNT-OBJID'} = $aCOOUNT_OBJID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\Account_1
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get accountno value
     * @return string
     */
    public function getAccountno()
    {
        return $this->accountno;
    }
    /**
     * Set accountno value
     * @param string $accountno
     * @return \StructType\Account_1
     */
    public function setAccountno($accountno = null)
    {
        // validation for constraint: string
        if (!is_null($accountno) && !is_string($accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountno, true), gettype($accountno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($accountno) && !preg_match('/([-+]){0,1}([0-9])*/', $accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($accountno, true)), __LINE__);
        }
        $this->accountno = $accountno;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Account_1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get credit value
     * @return string
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param string $credit
     * @return \StructType\Account_1
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: string
        if (!is_null($credit) && !is_string($credit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($credit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $credit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($credit, true)), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get debit value
     * @return string
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param string $debit
     * @return \StructType\Account_1
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: string
        if (!is_null($debit) && !is_string($debit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($debit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $debit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($debit, true)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get balance value
     * @return string
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \StructType\Account_1
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($balance) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($balance, true)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\Account_1
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get eventno value
     * @return string
     */
    public function getEventno()
    {
        return $this->eventno;
    }
    /**
     * Set eventno value
     * @param string $eventno
     * @return \StructType\Account_1
     */
    public function setEventno($eventno = null)
    {
        // validation for constraint: string
        if (!is_null($eventno) && !is_string($eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventno, true), gettype($eventno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($eventno) && !preg_match('/([-+]){0,1}([0-9])*/', $eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($eventno, true)), __LINE__);
        }
        $this->eventno = $eventno;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\Account_1
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\Account_1
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\Account_1
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
    /**
     * Get creditlimit value
     * @return string
     */
    public function getCreditlimit()
    {
        return $this->creditlimit;
    }
    /**
     * Set creditlimit value
     * @param string $creditlimit
     * @return \StructType\Account_1
     */
    public function setCreditlimit($creditlimit = null)
    {
        // validation for constraint: string
        if (!is_null($creditlimit) && !is_string($creditlimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditlimit, true), gettype($creditlimit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($creditlimit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $creditlimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($creditlimit, true)), __LINE__);
        }
        $this->creditlimit = $creditlimit;
        return $this;
    }
    /**
     * Get nopost value
     * @return string
     */
    public function getNopost()
    {
        return $this->nopost;
    }
    /**
     * Set nopost value
     * @param string $nopost
     * @return \StructType\Account_1
     */
    public function setNopost($nopost = null)
    {
        // validation for constraint: string
        if (!is_null($nopost) && !is_string($nopost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nopost, true), gettype($nopost)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($nopost) && !preg_match('/([-+]){0,1}([0-9])*/', $nopost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($nopost, true)), __LINE__);
        }
        $this->nopost = $nopost;
        return $this;
    }
    /**
     * Get paymentlink value
     * @return string
     */
    public function getPaymentlink()
    {
        return $this->paymentlink;
    }
    /**
     * Set paymentlink value
     * @param string $paymentlink
     * @return \StructType\Account_1
     */
    public function setPaymentlink($paymentlink = null)
    {
        // validation for constraint: string
        if (!is_null($paymentlink) && !is_string($paymentlink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentlink, true), gettype($paymentlink)), __LINE__);
        }
        $this->paymentlink = $paymentlink;
        return $this;
    }
    /**
     * Get Owner value
     * @return \StructType\Owner[]|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * This method is responsible for validating the values passed to the setOwner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOwner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOwnerForArrayConstraintsFromSetOwner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountOwnerItem) {
            // validation for constraint: itemType
            if (!$accountOwnerItem instanceof \StructType\Owner) {
                $invalidValues[] = is_object($accountOwnerItem) ? get_class($accountOwnerItem) : sprintf('%s(%s)', gettype($accountOwnerItem), var_export($accountOwnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Owner property can only contain items of type \StructType\Owner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Owner value
     * @throws \InvalidArgumentException
     * @param \StructType\Owner[] $owner
     * @return \StructType\Account_1
     */
    public function setOwner(array $owner = array())
    {
        // validation for constraint: array
        if ('' !== ($ownerArrayErrorMessage = self::validateOwnerForArrayConstraintsFromSetOwner($owner))) {
            throw new \InvalidArgumentException($ownerArrayErrorMessage, __LINE__);
        }
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Add item to Owner value
     * @throws \InvalidArgumentException
     * @param \StructType\Owner $item
     * @return \StructType\Account_1
     */
    public function addToOwner(\StructType\Owner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Owner) {
            throw new \InvalidArgumentException(sprintf('The Owner property can only contain items of type \StructType\Owner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Owner[] = $item;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountRoomItem) {
            // validation for constraint: itemType
            if (!$accountRoomItem instanceof \StructType\Room) {
                $invalidValues[] = is_object($accountRoomItem) ? get_class($accountRoomItem) : sprintf('%s(%s)', gettype($accountRoomItem), var_export($accountRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room[] $room
     * @return \StructType\Account_1
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room $item
     * @return \StructType\Account_1
     */
    public function addToRoom(\StructType\Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
}
