<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSearch StructType
 * @subpackage Structs
 */
class AccountSearch extends AbstractStructBase
{
    /**
     * The accountno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $accountno;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accounttype;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The accountHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountHolder;
    /**
     * The client
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $client;
    /**
     * The roomNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomNumber;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * Constructor method for AccountSearch
     * @uses AccountSearch::setAccountno()
     * @uses AccountSearch::setAccounttype()
     * @uses AccountSearch::setStatus()
     * @uses AccountSearch::setAccountHolder()
     * @uses AccountSearch::setClient()
     * @uses AccountSearch::setRoomNumber()
     * @uses AccountSearch::setArrival()
     * @uses AccountSearch::setDeparture()
     * @uses AccountSearch::setResno()
     * @param string $accountno
     * @param string $accounttype
     * @param string $status
     * @param string $accountHolder
     * @param string $client
     * @param string $roomNumber
     * @param string $arrival
     * @param string $departure
     * @param string $resno
     */
    public function __construct($accountno = null, $accounttype = null, $status = null, $accountHolder = null, $client = null, $roomNumber = null, $arrival = null, $departure = null, $resno = null)
    {
        $this
            ->setAccountno($accountno)
            ->setAccounttype($accounttype)
            ->setStatus($status)
            ->setAccountHolder($accountHolder)
            ->setClient($client)
            ->setRoomNumber($roomNumber)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setResno($resno);
    }
    /**
     * Get accountno value
     * @return string|null
     */
    public function getAccountno()
    {
        return $this->accountno;
    }
    /**
     * Set accountno value
     * @param string $accountno
     * @return \StructType\AccountSearch
     */
    public function setAccountno($accountno = null)
    {
        // validation for constraint: string
        if (!is_null($accountno) && !is_string($accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountno, true), gettype($accountno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($accountno) && !preg_match('/([-+]){0,1}([0-9])*/', $accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($accountno, true)), __LINE__);
        }
        $this->accountno = $accountno;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string|null
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\AccountSearch
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\AccountSearch
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get accountHolder value
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->accountHolder;
    }
    /**
     * Set accountHolder value
     * @param string $accountHolder
     * @return \StructType\AccountSearch
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolder, true), gettype($accountHolder)), __LINE__);
        }
        $this->accountHolder = $accountHolder;
        return $this;
    }
    /**
     * Get client value
     * @return string|null
     */
    public function getClient()
    {
        return $this->client;
    }
    /**
     * Set client value
     * @param string $client
     * @return \StructType\AccountSearch
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client, true), gettype($client)), __LINE__);
        }
        $this->client = $client;
        return $this;
    }
    /**
     * Get roomNumber value
     * @return string|null
     */
    public function getRoomNumber()
    {
        return $this->roomNumber;
    }
    /**
     * Set roomNumber value
     * @param string $roomNumber
     * @return \StructType\AccountSearch
     */
    public function setRoomNumber($roomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($roomNumber) && !is_string($roomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNumber, true), gettype($roomNumber)), __LINE__);
        }
        $this->roomNumber = $roomNumber;
        return $this;
    }
    /**
     * Get arrival value
     * @return string|null
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\AccountSearch
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string|null
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\AccountSearch
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get resno value
     * @return string|null
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\AccountSearch
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
}
