<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AUTHENTICATE-HOTEL StructType
 * @subpackage Structs
 */
class AUTHENTICATE_HOTEL extends AbstractStructBase
{
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * Constructor method for AUTHENTICATE-HOTEL
     * @uses AUTHENTICATE_HOTEL::setHotel()
     * @param string $hotel
     */
    public function __construct($hotel = null)
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\AUTHENTICATE_HOTEL
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
}
