<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALLOTMENT StructType
 * @subpackage Structs
 */
class ALLOTMENT extends AbstractStructBase
{
    /**
     * The ALLOTMENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENT_OBJID;
    /**
     * The ALLOTMENT_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENT_CENTRALID;
    /**
     * The contactpersonhotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $contactpersonhotel;
    /**
     * The contactpersonagency
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $contactpersonagency;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The contractnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $contractnumber;
    /**
     * The allotmentname
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $allotmentname;
    /**
     * The allotmenttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $allotmenttype;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The externalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externalid;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The guaranteetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guaranteetype;
    /**
     * The cancellationtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cancellationtype;
    /**
     * The releaseindays
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $releaseindays;
    /**
     * The releasetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $releasetype;
    /**
     * The optiontodate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $optiontodate;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The defaultpackage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $defaultpackage;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The resmedium
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $resmedium;
    /**
     * The allotmentowner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $allotmentowner;
    /**
     * The HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HOLDER[]
     */
    public $HOLDER;
    /**
     * The TRAVELAGENCY
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TRAVELAGENCY[]
     */
    public $TRAVELAGENCY;
    /**
     * The TRAVELPOINT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TRAVELPOINT[]
     */
    public $TRAVELPOINT;
    /**
     * Constructor method for ALLOTMENT
     * @uses ALLOTMENT::setALLOTMENT_OBJID()
     * @uses ALLOTMENT::setALLOTMENT_CENTRALID()
     * @uses ALLOTMENT::setContactpersonhotel()
     * @uses ALLOTMENT::setContactpersonagency()
     * @uses ALLOTMENT::setDatefrom()
     * @uses ALLOTMENT::setDateto()
     * @uses ALLOTMENT::setContractnumber()
     * @uses ALLOTMENT::setAllotmentname()
     * @uses ALLOTMENT::setAllotmenttype()
     * @uses ALLOTMENT::setComment()
     * @uses ALLOTMENT::setExternalid()
     * @uses ALLOTMENT::setCurrency()
     * @uses ALLOTMENT::setGuaranteetype()
     * @uses ALLOTMENT::setCancellationtype()
     * @uses ALLOTMENT::setReleaseindays()
     * @uses ALLOTMENT::setReleasetype()
     * @uses ALLOTMENT::setOptiontodate()
     * @uses ALLOTMENT::setRatesegment()
     * @uses ALLOTMENT::setDefaultpackage()
     * @uses ALLOTMENT::setMarketsegment()
     * @uses ALLOTMENT::setResmedium()
     * @uses ALLOTMENT::setAllotmentowner()
     * @uses ALLOTMENT::setHOLDER()
     * @uses ALLOTMENT::setTRAVELAGENCY()
     * @uses ALLOTMENT::setTRAVELPOINT()
     * @param string $aLLOTMENT_OBJID
     * @param string $aLLOTMENT_CENTRALID
     * @param string $contactpersonhotel
     * @param string $contactpersonagency
     * @param string $datefrom
     * @param string $dateto
     * @param string $contractnumber
     * @param string $allotmentname
     * @param string $allotmenttype
     * @param string $comment
     * @param string $externalid
     * @param string $currency
     * @param string $guaranteetype
     * @param string $cancellationtype
     * @param string $releaseindays
     * @param string $releasetype
     * @param string $optiontodate
     * @param string $ratesegment
     * @param string $defaultpackage
     * @param string $marketsegment
     * @param string $resmedium
     * @param string $allotmentowner
     * @param \StructType\HOLDER[] $hOLDER
     * @param \StructType\TRAVELAGENCY[] $tRAVELAGENCY
     * @param \StructType\TRAVELPOINT[] $tRAVELPOINT
     */
    public function __construct($aLLOTMENT_OBJID = null, $aLLOTMENT_CENTRALID = null, $contactpersonhotel = null, $contactpersonagency = null, $datefrom = null, $dateto = null, $contractnumber = null, $allotmentname = null, $allotmenttype = null, $comment = null, $externalid = null, $currency = null, $guaranteetype = null, $cancellationtype = null, $releaseindays = null, $releasetype = null, $optiontodate = null, $ratesegment = null, $defaultpackage = null, $marketsegment = null, $resmedium = null, $allotmentowner = null, array $hOLDER = array(), array $tRAVELAGENCY = array(), array $tRAVELPOINT = array())
    {
        $this
            ->setALLOTMENT_OBJID($aLLOTMENT_OBJID)
            ->setALLOTMENT_CENTRALID($aLLOTMENT_CENTRALID)
            ->setContactpersonhotel($contactpersonhotel)
            ->setContactpersonagency($contactpersonagency)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setContractnumber($contractnumber)
            ->setAllotmentname($allotmentname)
            ->setAllotmenttype($allotmenttype)
            ->setComment($comment)
            ->setExternalid($externalid)
            ->setCurrency($currency)
            ->setGuaranteetype($guaranteetype)
            ->setCancellationtype($cancellationtype)
            ->setReleaseindays($releaseindays)
            ->setReleasetype($releasetype)
            ->setOptiontodate($optiontodate)
            ->setRatesegment($ratesegment)
            ->setDefaultpackage($defaultpackage)
            ->setMarketsegment($marketsegment)
            ->setResmedium($resmedium)
            ->setAllotmentowner($allotmentowner)
            ->setHOLDER($hOLDER)
            ->setTRAVELAGENCY($tRAVELAGENCY)
            ->setTRAVELPOINT($tRAVELPOINT);
    }
    /**
     * Get ALLOTMENT_OBJID value
     * @return string
     */
    public function getALLOTMENT_OBJID()
    {
        return $this->{'ALLOTMENT-OBJID'};
    }
    /**
     * Set ALLOTMENT_OBJID value
     * @param string $aLLOTMENT_OBJID
     * @return \StructType\ALLOTMENT
     */
    public function setALLOTMENT_OBJID($aLLOTMENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENT_OBJID) && !is_string($aLLOTMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENT_OBJID, true), gettype($aLLOTMENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENT_OBJID) && !preg_match('/([0-9])*/', $aLLOTMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENT_OBJID, true)), __LINE__);
        }
        $this->ALLOTMENT_OBJID = $this->{'ALLOTMENT-OBJID'} = $aLLOTMENT_OBJID;
        return $this;
    }
    /**
     * Get ALLOTMENT_CENTRALID value
     * @return string
     */
    public function getALLOTMENT_CENTRALID()
    {
        return $this->{'ALLOTMENT-CENTRALID'};
    }
    /**
     * Set ALLOTMENT_CENTRALID value
     * @param string $aLLOTMENT_CENTRALID
     * @return \StructType\ALLOTMENT
     */
    public function setALLOTMENT_CENTRALID($aLLOTMENT_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENT_CENTRALID) && !is_string($aLLOTMENT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENT_CENTRALID, true), gettype($aLLOTMENT_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENT_CENTRALID) && !preg_match('/([0-9])*/', $aLLOTMENT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENT_CENTRALID, true)), __LINE__);
        }
        $this->ALLOTMENT_CENTRALID = $this->{'ALLOTMENT-CENTRALID'} = $aLLOTMENT_CENTRALID;
        return $this;
    }
    /**
     * Get contactpersonhotel value
     * @return string
     */
    public function getContactpersonhotel()
    {
        return $this->contactpersonhotel;
    }
    /**
     * Set contactpersonhotel value
     * @param string $contactpersonhotel
     * @return \StructType\ALLOTMENT
     */
    public function setContactpersonhotel($contactpersonhotel = null)
    {
        // validation for constraint: string
        if (!is_null($contactpersonhotel) && !is_string($contactpersonhotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactpersonhotel, true), gettype($contactpersonhotel)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($contactpersonhotel) && mb_strlen($contactpersonhotel) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($contactpersonhotel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($contactpersonhotel) && mb_strlen($contactpersonhotel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($contactpersonhotel)), __LINE__);
        }
        $this->contactpersonhotel = $contactpersonhotel;
        return $this;
    }
    /**
     * Get contactpersonagency value
     * @return string
     */
    public function getContactpersonagency()
    {
        return $this->contactpersonagency;
    }
    /**
     * Set contactpersonagency value
     * @param string $contactpersonagency
     * @return \StructType\ALLOTMENT
     */
    public function setContactpersonagency($contactpersonagency = null)
    {
        // validation for constraint: string
        if (!is_null($contactpersonagency) && !is_string($contactpersonagency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactpersonagency, true), gettype($contactpersonagency)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($contactpersonagency) && mb_strlen($contactpersonagency) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($contactpersonagency)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($contactpersonagency) && mb_strlen($contactpersonagency) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($contactpersonagency)), __LINE__);
        }
        $this->contactpersonagency = $contactpersonagency;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ALLOTMENT
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ALLOTMENT
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get contractnumber value
     * @return string
     */
    public function getContractnumber()
    {
        return $this->contractnumber;
    }
    /**
     * Set contractnumber value
     * @param string $contractnumber
     * @return \StructType\ALLOTMENT
     */
    public function setContractnumber($contractnumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractnumber) && !is_string($contractnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractnumber, true), gettype($contractnumber)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($contractnumber) && !preg_match('/([-+]){0,1}([0-9])*/', $contractnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($contractnumber, true)), __LINE__);
        }
        $this->contractnumber = $contractnumber;
        return $this;
    }
    /**
     * Get allotmentname value
     * @return string
     */
    public function getAllotmentname()
    {
        return $this->allotmentname;
    }
    /**
     * Set allotmentname value
     * @param string $allotmentname
     * @return \StructType\ALLOTMENT
     */
    public function setAllotmentname($allotmentname = null)
    {
        // validation for constraint: string
        if (!is_null($allotmentname) && !is_string($allotmentname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotmentname, true), gettype($allotmentname)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($allotmentname) && mb_strlen($allotmentname) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($allotmentname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($allotmentname) && mb_strlen($allotmentname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($allotmentname)), __LINE__);
        }
        $this->allotmentname = $allotmentname;
        return $this;
    }
    /**
     * Get allotmenttype value
     * @return string
     */
    public function getAllotmenttype()
    {
        return $this->allotmenttype;
    }
    /**
     * Set allotmenttype value
     * @param string $allotmenttype
     * @return \StructType\ALLOTMENT
     */
    public function setAllotmenttype($allotmenttype = null)
    {
        // validation for constraint: string
        if (!is_null($allotmenttype) && !is_string($allotmenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotmenttype, true), gettype($allotmenttype)), __LINE__);
        }
        $this->allotmenttype = $allotmenttype;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\ALLOTMENT
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get externalid value
     * @return string
     */
    public function getExternalid()
    {
        return $this->externalid;
    }
    /**
     * Set externalid value
     * @param string $externalid
     * @return \StructType\ALLOTMENT
     */
    public function setExternalid($externalid = null)
    {
        // validation for constraint: string
        if (!is_null($externalid) && !is_string($externalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalid, true), gettype($externalid)), __LINE__);
        }
        $this->externalid = $externalid;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ALLOTMENT
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get guaranteetype value
     * @return string
     */
    public function getGuaranteetype()
    {
        return $this->guaranteetype;
    }
    /**
     * Set guaranteetype value
     * @param string $guaranteetype
     * @return \StructType\ALLOTMENT
     */
    public function setGuaranteetype($guaranteetype = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteetype) && !is_string($guaranteetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteetype, true), gettype($guaranteetype)), __LINE__);
        }
        $this->guaranteetype = $guaranteetype;
        return $this;
    }
    /**
     * Get cancellationtype value
     * @return string
     */
    public function getCancellationtype()
    {
        return $this->cancellationtype;
    }
    /**
     * Set cancellationtype value
     * @param string $cancellationtype
     * @return \StructType\ALLOTMENT
     */
    public function setCancellationtype($cancellationtype = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationtype) && !is_string($cancellationtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationtype, true), gettype($cancellationtype)), __LINE__);
        }
        $this->cancellationtype = $cancellationtype;
        return $this;
    }
    /**
     * Get releaseindays value
     * @return string
     */
    public function getReleaseindays()
    {
        return $this->releaseindays;
    }
    /**
     * Set releaseindays value
     * @param string $releaseindays
     * @return \StructType\ALLOTMENT
     */
    public function setReleaseindays($releaseindays = null)
    {
        // validation for constraint: string
        if (!is_null($releaseindays) && !is_string($releaseindays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseindays, true), gettype($releaseindays)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($releaseindays) && !preg_match('/([-+]){0,1}([0-9])*/', $releaseindays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($releaseindays, true)), __LINE__);
        }
        $this->releaseindays = $releaseindays;
        return $this;
    }
    /**
     * Get releasetype value
     * @return string
     */
    public function getReleasetype()
    {
        return $this->releasetype;
    }
    /**
     * Set releasetype value
     * @param string $releasetype
     * @return \StructType\ALLOTMENT
     */
    public function setReleasetype($releasetype = null)
    {
        // validation for constraint: string
        if (!is_null($releasetype) && !is_string($releasetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releasetype, true), gettype($releasetype)), __LINE__);
        }
        $this->releasetype = $releasetype;
        return $this;
    }
    /**
     * Get optiontodate value
     * @return string
     */
    public function getOptiontodate()
    {
        return $this->optiontodate;
    }
    /**
     * Set optiontodate value
     * @param string $optiontodate
     * @return \StructType\ALLOTMENT
     */
    public function setOptiontodate($optiontodate = null)
    {
        // validation for constraint: string
        if (!is_null($optiontodate) && !is_string($optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optiontodate, true), gettype($optiontodate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($optiontodate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $optiontodate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($optiontodate, true)), __LINE__);
        }
        $this->optiontodate = $optiontodate;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ALLOTMENT
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get defaultpackage value
     * @return string
     */
    public function getDefaultpackage()
    {
        return $this->defaultpackage;
    }
    /**
     * Set defaultpackage value
     * @param string $defaultpackage
     * @return \StructType\ALLOTMENT
     */
    public function setDefaultpackage($defaultpackage = null)
    {
        // validation for constraint: string
        if (!is_null($defaultpackage) && !is_string($defaultpackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultpackage, true), gettype($defaultpackage)), __LINE__);
        }
        $this->defaultpackage = $defaultpackage;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\ALLOTMENT
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get resmedium value
     * @return string
     */
    public function getResmedium()
    {
        return $this->resmedium;
    }
    /**
     * Set resmedium value
     * @param string $resmedium
     * @return \StructType\ALLOTMENT
     */
    public function setResmedium($resmedium = null)
    {
        // validation for constraint: string
        if (!is_null($resmedium) && !is_string($resmedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resmedium, true), gettype($resmedium)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($resmedium) && mb_strlen($resmedium) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($resmedium)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($resmedium) && mb_strlen($resmedium) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($resmedium)), __LINE__);
        }
        $this->resmedium = $resmedium;
        return $this;
    }
    /**
     * Get allotmentowner value
     * @return string
     */
    public function getAllotmentowner()
    {
        return $this->allotmentowner;
    }
    /**
     * Set allotmentowner value
     * @param string $allotmentowner
     * @return \StructType\ALLOTMENT
     */
    public function setAllotmentowner($allotmentowner = null)
    {
        // validation for constraint: string
        if (!is_null($allotmentowner) && !is_string($allotmentowner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allotmentowner, true), gettype($allotmentowner)), __LINE__);
        }
        $this->allotmentowner = $allotmentowner;
        return $this;
    }
    /**
     * Get HOLDER value
     * @return \StructType\HOLDER[]|null
     */
    public function getHOLDER()
    {
        return $this->HOLDER;
    }
    /**
     * This method is responsible for validating the values passed to the setHOLDER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHOLDER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHOLDERForArrayConstraintsFromSetHOLDER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLLOTMENTHOLDERItem) {
            // validation for constraint: itemType
            if (!$aLLOTMENTHOLDERItem instanceof \StructType\HOLDER) {
                $invalidValues[] = is_object($aLLOTMENTHOLDERItem) ? get_class($aLLOTMENTHOLDERItem) : sprintf('%s(%s)', gettype($aLLOTMENTHOLDERItem), var_export($aLLOTMENTHOLDERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HOLDER property can only contain items of type \StructType\HOLDER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HOLDER value
     * @throws \InvalidArgumentException
     * @param \StructType\HOLDER[] $hOLDER
     * @return \StructType\ALLOTMENT
     */
    public function setHOLDER(array $hOLDER = array())
    {
        // validation for constraint: array
        if ('' !== ($hOLDERArrayErrorMessage = self::validateHOLDERForArrayConstraintsFromSetHOLDER($hOLDER))) {
            throw new \InvalidArgumentException($hOLDERArrayErrorMessage, __LINE__);
        }
        $this->HOLDER = $hOLDER;
        return $this;
    }
    /**
     * Add item to HOLDER value
     * @throws \InvalidArgumentException
     * @param \StructType\HOLDER $item
     * @return \StructType\ALLOTMENT
     */
    public function addToHOLDER(\StructType\HOLDER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HOLDER) {
            throw new \InvalidArgumentException(sprintf('The HOLDER property can only contain items of type \StructType\HOLDER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HOLDER[] = $item;
        return $this;
    }
    /**
     * Get TRAVELAGENCY value
     * @return \StructType\TRAVELAGENCY[]|null
     */
    public function getTRAVELAGENCY()
    {
        return $this->TRAVELAGENCY;
    }
    /**
     * This method is responsible for validating the values passed to the setTRAVELAGENCY method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTRAVELAGENCY method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTRAVELAGENCYForArrayConstraintsFromSetTRAVELAGENCY(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLLOTMENTTRAVELAGENCYItem) {
            // validation for constraint: itemType
            if (!$aLLOTMENTTRAVELAGENCYItem instanceof \StructType\TRAVELAGENCY) {
                $invalidValues[] = is_object($aLLOTMENTTRAVELAGENCYItem) ? get_class($aLLOTMENTTRAVELAGENCYItem) : sprintf('%s(%s)', gettype($aLLOTMENTTRAVELAGENCYItem), var_export($aLLOTMENTTRAVELAGENCYItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TRAVELAGENCY property can only contain items of type \StructType\TRAVELAGENCY, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TRAVELAGENCY value
     * @throws \InvalidArgumentException
     * @param \StructType\TRAVELAGENCY[] $tRAVELAGENCY
     * @return \StructType\ALLOTMENT
     */
    public function setTRAVELAGENCY(array $tRAVELAGENCY = array())
    {
        // validation for constraint: array
        if ('' !== ($tRAVELAGENCYArrayErrorMessage = self::validateTRAVELAGENCYForArrayConstraintsFromSetTRAVELAGENCY($tRAVELAGENCY))) {
            throw new \InvalidArgumentException($tRAVELAGENCYArrayErrorMessage, __LINE__);
        }
        $this->TRAVELAGENCY = $tRAVELAGENCY;
        return $this;
    }
    /**
     * Add item to TRAVELAGENCY value
     * @throws \InvalidArgumentException
     * @param \StructType\TRAVELAGENCY $item
     * @return \StructType\ALLOTMENT
     */
    public function addToTRAVELAGENCY(\StructType\TRAVELAGENCY $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRAVELAGENCY) {
            throw new \InvalidArgumentException(sprintf('The TRAVELAGENCY property can only contain items of type \StructType\TRAVELAGENCY, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TRAVELAGENCY[] = $item;
        return $this;
    }
    /**
     * Get TRAVELPOINT value
     * @return \StructType\TRAVELPOINT[]|null
     */
    public function getTRAVELPOINT()
    {
        return $this->TRAVELPOINT;
    }
    /**
     * This method is responsible for validating the values passed to the setTRAVELPOINT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTRAVELPOINT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTRAVELPOINTForArrayConstraintsFromSetTRAVELPOINT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLLOTMENTTRAVELPOINTItem) {
            // validation for constraint: itemType
            if (!$aLLOTMENTTRAVELPOINTItem instanceof \StructType\TRAVELPOINT) {
                $invalidValues[] = is_object($aLLOTMENTTRAVELPOINTItem) ? get_class($aLLOTMENTTRAVELPOINTItem) : sprintf('%s(%s)', gettype($aLLOTMENTTRAVELPOINTItem), var_export($aLLOTMENTTRAVELPOINTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TRAVELPOINT property can only contain items of type \StructType\TRAVELPOINT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TRAVELPOINT value
     * @throws \InvalidArgumentException
     * @param \StructType\TRAVELPOINT[] $tRAVELPOINT
     * @return \StructType\ALLOTMENT
     */
    public function setTRAVELPOINT(array $tRAVELPOINT = array())
    {
        // validation for constraint: array
        if ('' !== ($tRAVELPOINTArrayErrorMessage = self::validateTRAVELPOINTForArrayConstraintsFromSetTRAVELPOINT($tRAVELPOINT))) {
            throw new \InvalidArgumentException($tRAVELPOINTArrayErrorMessage, __LINE__);
        }
        $this->TRAVELPOINT = $tRAVELPOINT;
        return $this;
    }
    /**
     * Add item to TRAVELPOINT value
     * @throws \InvalidArgumentException
     * @param \StructType\TRAVELPOINT $item
     * @return \StructType\ALLOTMENT
     */
    public function addToTRAVELPOINT(\StructType\TRAVELPOINT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRAVELPOINT) {
            throw new \InvalidArgumentException(sprintf('The TRAVELPOINT property can only contain items of type \StructType\TRAVELPOINT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TRAVELPOINT[] = $item;
        return $this;
    }
}
