<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SSALESPOTENTIALMODIFYV ServiceType
 * @subpackage Services
 */
class SSALESPOTENTIALMODIFYV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_SALESPOTENTIAL_MODIFY_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service modifies an existing sales potential.### Input- SALESPOTENTIAL-OBJID: ObjID of the sales potential to be modified, which can be obtained from other defined services. Mandatory- All sales potential data to be
     * changed - status c - Newly Created a - Contact Attempted e - Contact Established p - Offer Preparation n - Negotiation - type m - mice l - logis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_SALESPOTENTIAL_MODIFY_V001Request $body
     * @return \StructType\S_SALESPOTENTIAL_MODIFY_V001Response|bool
     */
    public function S_SALESPOTENTIAL_MODIFY_V001(\StructType\S_SALESPOTENTIAL_MODIFY_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_SALESPOTENTIAL_MODIFY_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_SALESPOTENTIAL_MODIFY_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
