<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SROOMMAINTENANCESTATUSCHANGEV ServiceType
 * @subpackage Services
 */
class SROOMMAINTENANCESTATUSCHANGEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_ROOM_MAINTENANCE_STATUS_CHANGE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service changes the room status (maintenance status) of a given room.### Input- ROOM-OBJID: Mandatory. Object ID of the room, which can be obtained from defined services- maintenance: Mandatory. One of the configured
     * maintenance status for the hotel needs to be entered.- Standard maintenance status are (combo box '27' ): - 99 - Maintenance OK - 98 - General Maintenance - ...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Request $body
     * @return \StructType\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Response|bool
     */
    public function S_ROOM_MAINTENANCE_STATUS_CHANGE_V001(\StructType\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ROOM_MAINTENANCE_STATUS_CHANGE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ROOM_MAINTENANCE_STATUS_CHANGE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
