<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONROOMADDV ServiceType
 * @subpackage Services
 */
class SRESERVATIONROOMADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_RESERVATION_ROOM_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds rooms/persons to a reservation.### Input- RESERVATION-OBJID: ObjID of the reservation, which can be obtained from defined services. Mandatory- category: room category- noOfPax: number of persons-
     * noOfRooms: number of rooms- rateCategory: rate category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_ROOM_ADD_V001Request $body
     * @return \StructType\S_RESERVATION_ROOM_ADD_V001Response|bool
     */
    public function S_RESERVATION_ROOM_ADD_V001(\StructType\S_RESERVATION_ROOM_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_ROOM_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_ROOM_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
