<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONFROZENRATEDISCOUNTV ServiceType
 * @subpackage Services
 */
class SRESERVATIONFROZENRATEDISCOUNTV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_RESERVATION_FROZEN_RATE_DISCOUNT_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service discounts the frozen rates of a reservation. In order to use this functionality, it must be enabled in the SIHOT registry.### Input- RESERVATION-OBJID: ObjID of the reservation, which can be obtained from
     * other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Request $body
     * @return \StructType\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Response|bool
     */
    public function S_RESERVATION_FROZEN_RATE_DISCOUNT_V001(\StructType\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_FROZEN_RATE_DISCOUNT_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_FROZEN_RATE_DISCOUNT_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
