<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONDEPOSITINWITHSERVICEADDV ServiceType
 * @subpackage Services
 */
class SRESERVATIONDEPOSITINWITHSERVICEADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralPost deposit service on the reservation. Deposit amount can represent the reservation total or partly deposit.Prerequisites: Both of the following registry keys are set- Registry key: 1747; c=reservation,
     * v=procFactLstOnCheckIn- Registry key: 1748; c=reservation, v=procLstTypesOnCheckIn### Input- RESERVATION-CENTRALID: CentralID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the
     * reservation.- RESERVATION-OBJID: ObjID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- transactionID. Mandatory. The transaction ID of the payment.- typeofpayment.
     * Mandatory. Payment type for the payment.- paymentAmount. Mandatory. Amount of the payment (local currency).- approvalNumber. Mandatory. Approval number for the deposit in processing.- processingDate. Mandatory. Date of the deposit in processing.-
     * serviceProvider. Optional. The service provider used for the payment.- paymentDescription. Optional. Field for further description of the payment.- emailForDepositInvoice. Optional. Email address for deposit invoice.- service. Mandatory. Deposit
     * service for deposit in process.- amount. Mandatory. Amount for deposit in process.### Output- ACCOUNT-OBJID: ObjID of the RESERVATION-ACCOUNT on to the deposit was posted. For group reservations every reservation account is listed.- INVOICE-OBJID:
     * ObjID of the deposit invoice.- invoiceNo: Invoice no of the deposit invoice.- invoiceNoSet: Invoice set of the deposit invoice.- amount: Amount of the deposit invoice.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Request $body
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Response|bool
     */
    public function S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001(\StructType\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_SERVICE_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
