<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SRESERVATIONDEPOSITINWITHPAYMENTADDV ServiceType
 * @subpackage Services
 */
class SRESERVATIONDEPOSITINWITHPAYMENTADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralPost deposit on the reservation. Just a payment on the reservation account will be posted.Prerequisites: Both of the following registry keys are not set- Registry key: 1747; c=reservation, v=procFactLstOnCheckIn- Registry
     * key: 1748; c=reservation, v=procLstTypesOnCheckIn### Input- RESERVATION-CENTRALID: CentralID of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- RESERVATION-OBJID: ObjID
     * of the reservation. Optional, but one out of RESERVATION-CENTRALID or RESERVATION-OBJID needs to be sent to find the reservation.- transactionID. Mandatory. The transaction ID of the payment.- typeofpayment. Mandatory. Payment type for the payment.-
     * paymentAmount. Mandatory. Amount of the payment (local currency).- approvalNumber. Mandatory. Approval number for the deposit in processing.- processingDate. Mandatory. Date of the deposit in processing.- serviceProvider. Optional. The service
     * provider used for the payment.- paymentDescription. Optional. Field for further description of the payment.- emailForDepositInvoice. Optional. Email address for deposit invoice.### Output- ACCOUNT-OBJID: ObjID of the RESERVATION-ACCOUNT on to the
     * deposit was posted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Request $body
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Response|bool
     */
    public function S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001(\StructType\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_RESERVATION_DEPOSITIN_WITH_PAYMENT_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
